/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.fluid;

import com.enderio.core.common.fluid.IFluidWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class LegacyFluidWrapper
implements IFluidWrapper {
    private final IFluidHandler fluidHandler;
    private final EnumFacing side;

    public LegacyFluidWrapper(IFluidHandler fluidHandler, EnumFacing side) {
        this.fluidHandler = fluidHandler;
        this.side = side;
    }

    @Override
    public int offer(FluidStack resource) {
        return this.fluidHandler.fill(this.side, resource, false);
    }

    @Override
    public int fill(FluidStack resource) {
        return this.fluidHandler.fill(this.side, resource, true);
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource) {
        return this.fluidHandler.drain(this.side, resource, true);
    }

    @Override
    @Nullable
    public FluidStack getAvailableFluid() {
        return this.fluidHandler.drain(this.side, Integer.MAX_VALUE, false);
    }

    @Override
    @Nonnull
    public List<IFluidWrapper.ITankInfoWrapper> getTankInfoWrappers() {
        ArrayList<IFluidWrapper.ITankInfoWrapper> result = new ArrayList<IFluidWrapper.ITankInfoWrapper>();
        FluidTankInfo[] tankProperties = this.fluidHandler.getTankInfo(this.side);
        if (tankProperties != null) {
            for (FluidTankInfo tankProperty : tankProperties) {
                if (tankProperty == null) continue;
                result.add(new InfoWrapper(tankProperty));
            }
        }
        return result;
    }

    private static class InfoWrapper
    implements IFluidWrapper.ITankInfoWrapper {
        private final FluidTankInfo prop;

        private InfoWrapper(FluidTankInfo prop) {
            this.prop = prop;
        }

        @Override
        public IFluidTankProperties getIFluidTankProperties() {
            return new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return ((InfoWrapper)InfoWrapper.this).prop.fluid;
                }

                public int getCapacity() {
                    return ((InfoWrapper)InfoWrapper.this).prop.capacity;
                }

                public boolean canFill() {
                    return true;
                }

                public boolean canDrain() {
                    return true;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return true;
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return true;
                }
            };
        }

        @Override
        public FluidTankInfo getFluidTankInfo() {
            return this.prop;
        }
    }
}

