/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public abstract class MessageTileEntity<T extends TileEntity>
implements IMessage {
    private long pos;
    @Deprecated
    protected int x;
    @Deprecated
    protected int y;
    @Deprecated
    protected int z;

    protected MessageTileEntity() {
    }

    protected MessageTileEntity(T tile) {
        this.pos = tile.func_174877_v().func_177986_g();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = buf.readLong();
        BlockPos bp = this.getPos();
        this.x = bp.func_177958_n();
        this.y = bp.func_177956_o();
        this.z = bp.func_177952_p();
    }

    public BlockPos getPos() {
        return BlockPos.func_177969_a((long)this.pos);
    }

    protected T getTileEntity(World worldObj) {
        if (worldObj == null) {
            return null;
        }
        TileEntity te = worldObj.func_175625_s(this.getPos());
        if (te == null) {
            return null;
        }
        TypeToken teType = TypeToken.of(this.getClass()).resolveType(MessageTileEntity.class.getTypeParameters()[0]);
        if (teType.isAssignableFrom(te.getClass())) {
            return (T)te;
        }
        return null;
    }

    protected World getWorld(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b.field_70170_p;
    }
}

