/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class NetworkUtil {
    public static NBTTagCompound readNBTTagCompound(ByteBuf dataIn) {
        try {
            short size = dataIn.readShort();
            if (size < 0) {
                return null;
            }
            byte[] buffer = new byte[size];
            dataIn.readBytes(buffer);
            return CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(buffer));
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Custom Packet", true);
            return null;
        }
    }

    public static void writeNBTTagCompound(NBTTagCompound compound, ByteBuf dataout) {
        try {
            if (compound == null) {
                dataout.writeShort(-1);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)baos);
                byte[] buf = baos.toByteArray();
                dataout.writeShort((int)((short)buf.length));
                dataout.writeBytes(buf);
            }
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "PacketUtil.readTileEntityPacket.writeNBTTagCompound", true);
        }
    }

    public static byte[] readByteArray(ByteBuf buf) {
        int size = buf.readMedium();
        byte[] res = new byte[size];
        buf.readBytes(res);
        return res;
    }

    public static void writeByteArray(ByteBuf buf, byte[] arr) {
        buf.writeMedium(arr.length);
        buf.writeBytes(arr);
    }
}

