/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.recipes.IVariableFermentable;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.items.IColoredItem;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Translator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGermlingGE
extends ItemGE
implements IVariableFermentable,
IColoredItem {
    private final EnumGermlingType type;

    public ItemGermlingGE(EnumGermlingType type) {
        super(Tabs.tabArboriculture);
        this.type = type;
    }

    @Override
    public ITree getIndividual(ItemStack itemstack) {
        return new Tree(itemstack.func_77978_p());
    }

    @Override
    protected IAlleleTreeSpecies getSpecies(ItemStack itemStack) {
        return TreeGenome.getSpecies(itemStack);
    }

    private static IAlleleTreeSpecies getSpeciesOrDefault(ItemStack itemstack) {
        IAlleleTreeSpecies treeSpecies = TreeGenome.getSpecies(itemstack);
        if (treeSpecies == null) {
            treeSpecies = TreeDefinition.Oak.getGenome().getPrimary();
        }
        return treeSpecies;
    }

    public String func_77653_i(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return "Unknown";
        }
        IAlleleTreeSpecies species = this.getSpecies(itemstack);
        String customTreeKey = "for.trees.custom." + this.type.getName() + "." + species.getUnlocalizedName().replace("trees.species.", "");
        if (Translator.canTranslateToLocal(customTreeKey)) {
            return Translator.translateToLocal(customTreeKey);
        }
        String typeString = Translator.translateToLocal("for.trees.grammar." + this.type.getName() + ".type");
        return Translator.translateToLocal("for.trees.grammar." + this.type.getName()).replaceAll("%SPECIES", species.getName()).replaceAll("%TYPE", typeString);
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List<ItemStack> itemList, boolean hideSecrets) {
        for (IIndividual iIndividual : TreeManager.treeRoot.getIndividualTemplates()) {
            if (hideSecrets && iIndividual.isSecret() && !Config.isDebug) continue;
            itemList.add(TreeManager.treeRoot.getMemberStack(iIndividual, this.type));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack itemstack, int renderPass) {
        return ItemGermlingGE.getSpeciesOrDefault(itemstack).getGermlingColour(this.type, renderPass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, new GermlingMeshDefinition());
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleTreeSpecies)) continue;
            ((IAlleleTreeSpecies)allele).registerModels(item, manager, this.type);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = raytraceresult.func_178782_a();
            ITree tree = TreeManager.treeRoot.getMember(itemStackIn);
            if (tree != null) {
                if (this.type == EnumGermlingType.SAPLING) {
                    return ItemGermlingGE.onItemRightClickSapling(itemStackIn, worldIn, playerIn, pos, tree);
                }
                if (this.type == EnumGermlingType.POLLEN) {
                    return ItemGermlingGE.onItemRightClickPollen(itemStackIn, worldIn, playerIn, pos, tree);
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Nonnull
    private static ActionResult<ItemStack> onItemRightClickPollen(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, BlockPos pos, ITree tree) {
        ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(worldIn, pos);
        if (checkPollinatable == null || !checkPollinatable.canMateWith(tree)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        IPollinatable pollinatable = GeneticsUtil.getOrCreatePollinatable(playerIn.func_146103_bH(), worldIn, pos);
        if (pollinatable == null || !pollinatable.canMateWith(tree)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        pollinatable.mateWith(tree);
        IBlockState blockState = worldIn.func_180495_p(pos);
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, blockState);
        Proxies.net.sendNetworkPacket(packet, worldIn);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            --itemStackIn.field_77994_a;
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Nonnull
    private static ActionResult<ItemStack> onItemRightClickSapling(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, BlockPos pos, ITree tree) {
        IBlockState hitBlock = worldIn.func_180495_p(pos);
        if (!hitBlock.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
            }
            pos = pos.func_177984_a();
        }
        if (tree.canStay((IBlockAccess)worldIn, pos) && TreeManager.treeRoot.plantSapling(worldIn, tree, playerIn.func_146103_bH(), pos)) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --itemStackIn.field_77994_a;
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    @Override
    public float getFermentationModifier(ItemStack itemstack) {
        ITree tree = TreeManager.treeRoot.getMember(itemstack);
        if (tree == null) {
            return 1.0f;
        }
        return tree.getGenome().getSappiness() * 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private class GermlingMeshDefinition
    implements ItemMeshDefinition {
        private GermlingMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            IAlleleTreeSpecies treeSpecies = ItemGermlingGE.this.getSpecies(stack);
            if (treeSpecies == null) {
                treeSpecies = TreeDefinition.Oak.getGenome().getPrimary();
            }
            return treeSpecies.getGermlingModel(ItemGermlingGE.this.type);
        }
    }
}

