/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.IPickupHandler;
import forestry.core.ISaveEventHandler;
import forestry.core.errors.ErrorStateRegistry;
import forestry.core.loot.LootTableLoader;
import forestry.core.models.ModelBlockCached;
import forestry.core.render.TextureManager;
import forestry.plugins.PluginManager;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandlerCore {
    @SubscribeEvent
    public void handleItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        for (IPickupHandler handler : PluginManager.pickupHandlers) {
            if (!handler.onItemPickup(event.getEntityPlayer(), event.getItem())) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    @SubscribeEvent
    public void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player != null) {
            Collection<ISpeciesRoot> speciesRoots = AlleleManager.alleleRegistry.getSpeciesRoot().values();
            for (ISpeciesRoot speciesRoot : speciesRoots) {
                IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(player.func_130014_f_(), player.func_146103_bH());
                breedingTracker.synchToPlayer(player);
            }
        }
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldLoad(event.getWorld());
        }
    }

    @SubscribeEvent
    public void handleWorldSave(WorldEvent.Save event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldSave(event.getWorld());
        }
    }

    @SubscribeEvent
    public void handleWorldUnload(WorldEvent.Unload event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldUnload(event.getWorld());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        ErrorStateRegistry.initSprites();
        TextureManager.initDefaultSprites();
        ModelBlockCached.clear();
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        if (!event.getName().func_110624_b().equals("minecraft")) {
            return;
        }
        ResourceLocation resourceLocation = new ResourceLocation("forestry", event.getName().func_110623_a());
        LootTable forestryChestAdditions = LootTableLoader.loadBuiltinLootTable(resourceLocation);
        if (forestryChestAdditions != null) {
            for (String poolName : PluginManager.getLootPoolNames()) {
                LootPool pool = forestryChestAdditions.getPool(poolName);
                if (pool == null) continue;
                event.getTable().addPool(pool);
            }
        }
    }
}

