/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import forestry.core.genetics.alleles.Allele;
import forestry.core.utils.Translator;
import org.apache.commons.lang3.text.WordUtils;

public abstract class AlleleCategorized
extends Allele {
    protected AlleleCategorized(String modId, String category, String valueName, boolean isDominant) {
        super(AlleleCategorized.getUid(modId, category, valueName), AlleleCategorized.getUnlocalizedName(modId, category, valueName), isDominant);
    }

    private static String getUid(String modId, String category, String valueName) {
        return modId + '.' + category + WordUtils.capitalize((String)valueName);
    }

    private static String getUnlocalizedName(String modId, String category, String valueName) {
        String customName = modId + '.' + "allele." + category + '.' + valueName;
        if (Translator.canTranslateToLocal(customName)) {
            return customName;
        }
        return modId + '.' + "allele." + valueName;
    }
}

