/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.mojang.authlib.GameProfile;
import forestry.api.core.INbtWritable;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.core.utils.PlayerUtil;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MailAddress
implements INbtWritable,
IMailAddress {
    private static final GameProfile invalidGameProfile = new GameProfile(new UUID(0L, 0L), "");
    @Nonnull
    private final EnumAddressee type;
    @Nonnull
    private final GameProfile gameProfile;

    public MailAddress() {
        this.type = EnumAddressee.PLAYER;
        this.gameProfile = invalidGameProfile;
    }

    public MailAddress(@Nonnull GameProfile gameProfile) {
        if (gameProfile == null) {
            throw new IllegalArgumentException("gameProfile must not be null");
        }
        this.type = EnumAddressee.PLAYER;
        this.gameProfile = gameProfile;
    }

    public MailAddress(@Nonnull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.type = EnumAddressee.TRADER;
        this.gameProfile = new GameProfile(null, name);
    }

    public MailAddress(@Nonnull NBTTagCompound nbt) {
        EnumAddressee type = null;
        GameProfile gameProfile = null;
        if (nbt.func_74764_b("TP")) {
            String typeName = nbt.func_74779_i("TP");
            type = EnumAddressee.fromString(typeName);
        }
        if (type == null) {
            type = EnumAddressee.PLAYER;
            gameProfile = invalidGameProfile;
        } else if (nbt.func_74764_b("profile")) {
            NBTTagCompound profileTag = nbt.func_74775_l("profile");
            gameProfile = PlayerUtil.readGameProfileFromNBT(profileTag);
        }
        this.type = type;
        this.gameProfile = gameProfile;
    }

    @Override
    @Nonnull
    public EnumAddressee getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.gameProfile.getName();
    }

    @Override
    public boolean isValid() {
        return this.gameProfile.getName() != null && !PlayerUtil.isSameGameProfile(this.gameProfile, invalidGameProfile);
    }

    @Override
    public GameProfile getPlayerProfile() {
        if (this.type != EnumAddressee.PLAYER) {
            return null;
        }
        return this.gameProfile;
    }

    public int hashCode() {
        return this.gameProfile.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MailAddress)) {
            return false;
        }
        MailAddress address = (MailAddress)o;
        return PlayerUtil.isSameGameProfile(address.gameProfile, this.gameProfile);
    }

    public String toString() {
        String name = this.getName().toLowerCase(Locale.ENGLISH);
        if (this.getType() == EnumAddressee.PLAYER) {
            return (Object)((Object)this.type) + "-" + name + '-' + this.gameProfile.getId();
        }
        return (Object)((Object)this.type) + "-" + name;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("TP", this.type.toString());
        if (this.gameProfile != null) {
            NBTTagCompound profileNbt = new NBTTagCompound();
            PlayerUtil.writeGameProfile(profileNbt, this.gameProfile);
            nbttagcompound.func_74782_a("profile", (NBTBase)profileNbt);
        }
        return nbttagcompound;
    }
}

