/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.storage.IBackpackFilterConfigurable;
import forestry.core.utils.ItemStackUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BackpackFilter
implements IBackpackFilterConfigurable {
    private final Set<String> acceptedItemStacks = new HashSet<String>();
    private final Set<String> rejectedItemStacks = new HashSet<String>();
    private final Set<Integer> validOreIds = new HashSet<Integer>();

    @Override
    public void acceptItem(ItemStack validItem) {
        String itemStackString = ItemStackUtil.getStringForItemStack(validItem);
        if (itemStackString != null) {
            this.acceptedItemStacks.add(itemStackString);
        }
    }

    @Override
    public void acceptOreDictName(String oreDictName) {
        if (OreDictionary.doesOreNameExist((String)oreDictName)) {
            int oreId = OreDictionary.getOreID((String)oreDictName);
            this.validOreIds.add(oreId);
        }
    }

    @Override
    public void rejectOreDictName(String oreDictName) {
        if (OreDictionary.doesOreNameExist((String)oreDictName)) {
            int oreId = OreDictionary.getOreID((String)oreDictName);
            this.validOreIds.remove(oreId);
        }
    }

    @Override
    public void rejectItem(ItemStack invalidItem) {
        String itemStackString = ItemStackUtil.getStringForItemStack(invalidItem);
        if (itemStackString != null) {
            this.rejectedItemStacks.add(itemStackString);
        }
    }

    @Override
    public void clear() {
        this.acceptedItemStacks.clear();
        this.rejectedItemStacks.clear();
        this.validOreIds.clear();
    }

    @Override
    public boolean test(ItemStack itemStack) {
        int[] oreIds;
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return false;
        }
        String itemStackStringWild = ItemStackUtil.getItemNameFromRegistryAsString(item);
        if (this.rejectedItemStacks.contains(itemStackStringWild)) {
            return false;
        }
        if (this.acceptedItemStacks.contains(itemStackStringWild)) {
            return true;
        }
        int meta = itemStack.func_77960_j();
        if (meta != Short.MAX_VALUE) {
            String itemStackString = itemStackStringWild + ':' + meta;
            if (this.rejectedItemStacks.contains(itemStackString)) {
                return false;
            }
            if (this.acceptedItemStacks.contains(itemStackString)) {
                return true;
            }
        }
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)itemStack)) {
            if (!this.validOreIds.contains(oreId)) continue;
            this.acceptedItemStacks.add(itemStackStringWild);
            return true;
        }
        return false;
    }

    public Set<Integer> getValidOreIds() {
        return this.validOreIds;
    }

    public Set<String> getAcceptedItemStacks() {
        return this.acceptedItemStacks;
    }

    public Set<String> getRejectedItemStacks() {
        return this.rejectedItemStacks;
    }
}

