/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import forestry.Forestry;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.IBackpackFilterConfigurable;
import forestry.api.storage.StorageManager;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.blocks.BlockRegistryApiculture;
import forestry.core.IPickupHandler;
import forestry.core.IResupplyHandler;
import forestry.core.PluginCore;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.items.ItemCrated;
import forestry.core.models.ModelCrate;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.IMCUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.lepidopterology.PluginLepidopterology;
import forestry.lepidopterology.blocks.BlockRegistryLepidopterology;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import forestry.storage.BackpackDefinition;
import forestry.storage.BackpackInterface;
import forestry.storage.CrateRegistry;
import forestry.storage.PickupHandlerStorage;
import forestry.storage.ResupplyHandler;
import forestry.storage.items.ItemRegistryStorage;
import forestry.storage.proxy.ProxyStorage;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@ForestryPlugin(pluginID="forestry.storage", name="Storage", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.storage.description")
public class PluginStorage
extends BlankForestryPlugin {
    @SidedProxy(clientSide="forestry.storage.proxy.ProxyStorageClient", serverSide="forestry.storage.proxy.ProxyStorage")
    public static ProxyStorage proxy;
    private static final List<ItemCrated> crates;
    private static final String CONFIG_CATEGORY = "backpacks";
    public static ItemRegistryStorage items;
    private final Multimap<String, String> backpackAcceptedOreDictRegexpDefaults = HashMultimap.create();
    private final Multimap<String, String> backpackRejectedOreDictRegexpDefaults = HashMultimap.create();
    private final Multimap<String, String> backpackAcceptedItemDefaults = HashMultimap.create();
    private final Multimap<String, String> backpackRejectedItemDefaults = HashMultimap.create();
    private final List<String> forestryBackpackUids = Arrays.asList("forestry.miner", "forestry.digger", "forestry.forester", "forestry.hunter", "forestry.adventurer", "forestry.builder");

    @Override
    public void setupAPI() {
        BackpackDefinition definition;
        Predicate<ItemStack> filter;
        super.setupAPI();
        StorageManager.crateRegistry = new CrateRegistry();
        BackpackManager.backpackInterface = new BackpackInterface();
        if (ForestryAPI.enabledPlugins.contains("forestry.apiculture")) {
            filter = BackpackManager.backpackInterface.createNaturalistBackpackFilter("rootBees");
            definition = new BackpackDefinition(new Color(12882493), Color.WHITE, filter);
            BackpackManager.backpackInterface.registerBackpackDefinition("apiarist", definition);
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.lepidopterology")) {
            filter = BackpackManager.backpackInterface.createNaturalistBackpackFilter("rootButterflies");
            definition = new BackpackDefinition(new Color(10050353), Color.WHITE, filter);
            BackpackManager.backpackInterface.registerBackpackDefinition("lepidopterist", definition);
        }
        definition = new BackpackDefinition(new Color(3545213), Color.WHITE);
        BackpackManager.backpackInterface.registerBackpackDefinition("forestry.miner", definition);
        definition = new BackpackDefinition(new Color(3554501), Color.WHITE);
        BackpackManager.backpackInterface.registerBackpackDefinition("forestry.digger", definition);
        definition = new BackpackDefinition(new Color(3437607), Color.WHITE);
        BackpackManager.backpackInterface.registerBackpackDefinition("forestry.forester", definition);
        definition = new BackpackDefinition(new Color(4268565), Color.WHITE);
        BackpackManager.backpackInterface.registerBackpackDefinition("forestry.hunter", definition);
        definition = new BackpackDefinition(new Color(8370370), Color.WHITE);
        BackpackManager.backpackInterface.registerBackpackDefinition("forestry.adventurer", definition);
        definition = new BackpackDefinition(new Color(0xDD3A3A), Color.WHITE);
        BackpackManager.backpackInterface.registerBackpackDefinition("forestry.builder", definition);
        proxy.registerCrateModel();
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryStorage();
    }

    @Override
    public void preInit() {
        PluginStorage.registerFenceAndFenceGatesToOreDict();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void postInit() {
        boolean deleted;
        String newConfig = "backpacks.cfg";
        File configFile = new File(Forestry.instance.getConfigFolder(), "backpacks.cfg");
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "2.0.0");
        if (!config.getDefinedConfigVersion().equals(config.getLoadedConfigVersion()) && (deleted = configFile.delete())) {
            config = new LocalizedConfiguration(configFile, "2.0.0");
        }
        this.setDefaultsForConfig();
        for (String backpackUid : this.forestryBackpackUids) {
            this.handleBackpackConfig(config, backpackUid);
        }
        config.save();
    }

    private void setDefaultsForConfig() {
        this.backpackAcceptedOreDictRegexpDefaults.get((Object)"forestry.miner").addAll(Arrays.asList("obsidian", "ore[A-Z].*", "dust[A-Z].*", "gem[A-Z].*", "ingot[A-Z].*", "nugget[A-Z].*", "crushed[A-Z].*", "cluster[A-Z].*", "denseore[A-Z].*"));
        this.backpackAcceptedOreDictRegexpDefaults.get((Object)"forestry.digger").addAll(Arrays.asList("cobblestone", "dirt", "gravel", "netherrack", "stone", "stone[A-Z].*", "sand"));
        this.backpackAcceptedOreDictRegexpDefaults.get((Object)"forestry.hunter").addAll(Arrays.asList("bone", "egg", "enderpearl", "feather", "fish[A-Z].*", "gunpowder", "leather", "slimeball", "string"));
        this.backpackAcceptedOreDictRegexpDefaults.get((Object)"forestry.forester").addAll(Arrays.asList("logWood", "stickWood", "woodStick", "saplingTree", "treeSapling", "vine", "sugarcane", "blockCactus", "crop[A-Z].*", "seed[A-Z].*", "tree[A-Z].*"));
        this.backpackAcceptedOreDictRegexpDefaults.get((Object)"forestry.builder").addAll(Arrays.asList("block[A-Z].*", "paneGlass[A-Z].*", "slabWood[A-Z].*", "stainedClay[A-Z].*", "stainedGlass[A-Z].*", "stone", "sandstone", "plankWood", "stairWood", "slabWood", "fenceWood", "fenceGateWood", "trapdoorWood", "glass", "paneGlass", "torch", "chest", "chest[A-Z].*", "workbench", "doorWood"));
        this.backpackAcceptedItemDefaults.get((Object)"forestry.miner").addAll(PluginStorage.getItemStrings(Arrays.asList(new ItemStack(Blocks.field_150365_q), new ItemStack(Items.field_151044_h), PluginCore.items.bronzePickaxe.getItemStack(), PluginCore.items.kitPickaxe.getItemStack(), PluginCore.items.brokenBronzePickaxe.getItemStack())));
        this.backpackAcceptedItemDefaults.get((Object)"forestry.digger").addAll(PluginStorage.getItemStrings(Arrays.asList(new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE), new ItemStack(Items.field_151145_ak), new ItemStack(Blocks.field_150322_A, 1, 0), new ItemStack(Items.field_151119_aD), new ItemStack(Items.field_151126_ay), new ItemStack(Blocks.field_150425_aM), PluginCore.items.bronzeShovel.getItemStack(), PluginCore.items.kitShovel.getItemStack(), PluginCore.items.brokenBronzeShovel.getItemStack())));
        this.backpackAcceptedItemDefaults.get((Object)"forestry.forester").addAll(PluginStorage.getItemStrings(Arrays.asList(new ItemStack((Block)Blocks.field_150337_Q), new ItemStack((Block)Blocks.field_150338_P), new ItemStack((Block)Blocks.field_150328_O, 1, Short.MAX_VALUE), new ItemStack((Block)Blocks.field_150327_N), new ItemStack((Block)Blocks.field_150329_H, 1, Short.MAX_VALUE), new ItemStack((Block)Blocks.field_150398_cm, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150423_aK), new ItemStack(Blocks.field_150440_ba), new ItemStack(Items.field_151153_ao), new ItemStack(Items.field_151075_bm), new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151080_bb), new ItemStack(Items.field_151081_bc), new ItemStack(Items.field_185163_cU), new ItemStack(Items.field_185164_cV), new ItemStack(Items.field_185161_cS), new ItemStack(Items.field_151034_e))));
        this.backpackAcceptedItemDefaults.get((Object)"forestry.hunter").addAll(PluginStorage.getItemStrings(Arrays.asList(new ItemStack(Items.field_151065_br), new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE), new ItemStack(Items.field_151073_bk), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151032_g), new ItemStack(Items.field_185166_h), new ItemStack(Items.field_185167_i), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151157_am), new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151083_be), new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151077_bg), new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_179557_bn), new ItemStack(Items.field_179558_bo), new ItemStack(Items.field_179559_bp), new ItemStack(Items.field_179556_br), new ItemStack(Items.field_179555_bs), new ItemStack(Items.field_151070_bp), new ItemStack(Items.field_151071_bq), new ItemStack(Items.field_151100_aR, 1, 0), new ItemStack(Blocks.field_150407_cf), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new ItemStack(Items.field_151061_bv), new ItemStack(Items.field_151064_bs), new ItemStack(Items.field_151060_bw), new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE), new ItemStack(Items.field_179566_aV, 1, Short.MAX_VALUE), new ItemStack(Items.field_151058_ca), new ItemStack((Item)Items.field_151112_aM), new ItemStack(Items.field_151057_cb), new ItemStack(Items.field_151141_av), new ItemStack(Items.field_151125_bZ), new ItemStack(Items.field_151136_bY), new ItemStack(Items.field_151138_bX))));
        this.backpackAcceptedItemDefaults.get((Object)"forestry.builder").addAll(PluginStorage.getItemStrings(Arrays.asList(new ItemStack(Blocks.field_150429_aA), new ItemStack(Blocks.field_150379_bu), new ItemStack(Blocks.field_180398_cJ), new ItemStack(Blocks.field_185764_cQ), new ItemStack(Blocks.field_150417_aV, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150336_V), new ItemStack(Blocks.field_150435_aG), new ItemStack(Blocks.field_150405_ch, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150403_cj), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150386_bk), new ItemStack(Blocks.field_150462_ai), new ItemStack(Blocks.field_150460_al), new ItemStack(Blocks.field_150442_at), new ItemStack(Blocks.field_150367_z), new ItemStack(Blocks.field_150409_cd), new ItemStack(Blocks.field_150468_ap), new ItemStack(Blocks.field_150411_aY), new ItemStack(Blocks.field_150371_ca, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150370_cb), new ItemStack(Blocks.field_150372_bz), new ItemStack(Blocks.field_180396_cN), new ItemStack(Blocks.field_150463_bK, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150430_aB), new ItemStack(Blocks.field_150471_bO), new ItemStack((Block)Blocks.field_150333_U, 1, Short.MAX_VALUE), new ItemStack((Block)Blocks.field_180389_cP, 1, Short.MAX_VALUE), new ItemStack((Block)Blocks.field_150376_bx, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_185767_cT), new ItemStack(Blocks.field_185768_cU), new ItemStack(Blocks.field_185769_cV), new ItemStack((Block)Blocks.field_185771_cX), new ItemStack(Blocks.field_185772_cY), new ItemStack(Blocks.field_150404_cg, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_180400_cw), new ItemStack(Blocks.field_150456_au), new ItemStack(Blocks.field_150452_aw), new ItemStack(Blocks.field_150445_bS), new ItemStack(Blocks.field_150443_bT), new ItemStack(Items.field_151155_ap), new ItemStack(Items.field_151160_bD), new ItemStack(Items.field_179572_au), new ItemStack(Items.field_179568_as), new ItemStack(Items.field_179571_av), new ItemStack(Items.field_151139_aw), new ItemStack(Items.field_179567_at), new ItemStack(Items.field_179570_aq), new ItemStack(Items.field_179569_ar))));
        BlockRegistryApiculture beeBlocks = PluginApiculture.blocks;
        if (beeBlocks != null) {
            this.backpackAcceptedItemDefaults.get((Object)"forestry.builder").addAll(PluginStorage.getItemStrings(Arrays.asList(new ItemStack((Block)beeBlocks.candle, 1, Short.MAX_VALUE), new ItemStack((Block)beeBlocks.stump, 1, Short.MAX_VALUE))));
        }
        BackpackInterface backpackInterface = (BackpackInterface)BackpackManager.backpackInterface;
        this.backpackAcceptedItemDefaults.putAll(backpackInterface.getBackpackAcceptedItems());
    }

    private static void registerFenceAndFenceGatesToOreDict() {
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180407_aO);
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180408_aP);
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180404_aQ);
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180403_aR);
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180406_aS);
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180405_aT);
        OreDictionary.registerOre((String)"fenceGateWood", (Block)Blocks.field_180390_bo);
        OreDictionary.registerOre((String)"fenceGateWood", (Block)Blocks.field_180391_bp);
        OreDictionary.registerOre((String)"fenceGateWood", (Block)Blocks.field_180392_bq);
        OreDictionary.registerOre((String)"fenceGateWood", (Block)Blocks.field_180386_br);
        OreDictionary.registerOre((String)"fenceGateWood", (Block)Blocks.field_180385_bs);
        OreDictionary.registerOre((String)"fenceGateWood", (Block)Blocks.field_180387_bt);
    }

    @Nonnull
    private static Set<String> getItemStrings(List<ItemStack> itemStacks) {
        HashSet<String> itemStrings = new HashSet<String>(itemStacks.size());
        for (ItemStack itemStack : itemStacks) {
            String itemString = ItemStackUtil.getStringForItemStack(itemStack);
            itemStrings.add(itemString);
        }
        return itemStrings;
    }

    private void handleBackpackConfig(LocalizedConfiguration config, String backpackUid) {
        BackpackDefinition backpackDefinition = (BackpackDefinition)BackpackManager.backpackInterface.getBackpackDefinition(backpackUid);
        if (backpackDefinition == null) {
            return;
        }
        Predicate<ItemStack> filter = backpackDefinition.getFilter();
        if (filter instanceof IBackpackFilterConfigurable) {
            IBackpackFilterConfigurable backpackFilter = (IBackpackFilterConfigurable)filter;
            backpackFilter.clear();
            ArrayList defaultAcceptedItemNames = new ArrayList(this.backpackAcceptedItemDefaults.get((Object)backpackUid));
            Collections.sort(defaultAcceptedItemNames);
            String[] defaultValidItems = defaultAcceptedItemNames.toArray(new String[defaultAcceptedItemNames.size()]);
            Property backpackConf = config.get("backpacks." + backpackUid, "item.stacks.accepted", defaultValidItems);
            backpackConf.setComment(Translator.translateToLocalFormatted("for.config.backpacks.item.stacks.format", backpackUid));
            String[] backpackItemList = backpackConf.getStringList();
            List<ItemStack> backpackItems = ItemStackUtil.parseItemStackStrings(backpackItemList, Short.MAX_VALUE);
            for (ItemStack backpackItem : backpackItems) {
                backpackFilter.acceptItem(backpackItem);
            }
            ArrayList defaultRejectedItemNames = new ArrayList(this.backpackRejectedItemDefaults.get((Object)backpackUid));
            Collections.sort(defaultRejectedItemNames);
            String[] defaultRejectedItems = defaultRejectedItemNames.toArray(new String[defaultRejectedItemNames.size()]);
            backpackConf = config.get("backpacks." + backpackUid, "item.stacks.rejected", defaultRejectedItems);
            backpackConf.setComment(Translator.translateToLocalFormatted("for.config.backpacks.item.stacks.format", backpackUid));
            backpackItemList = backpackConf.getStringList();
            backpackItems = ItemStackUtil.parseItemStackStrings(backpackItemList, Short.MAX_VALUE);
            for (ItemStack backpackItem : backpackItems) {
                backpackFilter.rejectItem(backpackItem);
            }
            ArrayList defaultOreRegexpList = new ArrayList(this.backpackAcceptedOreDictRegexpDefaults.get((Object)backpackUid));
            Collections.sort(defaultOreRegexpList);
            String[] defaultOreRegexpNames = defaultOreRegexpList.toArray(new String[defaultOreRegexpList.size()]);
            backpackConf = config.get("backpacks." + backpackUid, "ore.dict.accepted", defaultOreRegexpNames);
            backpackConf.setComment(Translator.translateToLocalFormatted("for.config.backpacks.ore.dict.format", backpackUid));
            for (String name : OreDictionary.getOreNames()) {
                if (name == null) {
                    Log.error("Found a null oreName in the ore dictionary", new Object[0]);
                    continue;
                }
                for (String regex : backpackConf.getStringList()) {
                    if (!name.matches(regex)) continue;
                    backpackFilter.acceptOreDictName(name);
                }
            }
            defaultOreRegexpList = new ArrayList(this.backpackRejectedOreDictRegexpDefaults.get((Object)backpackUid));
            Collections.sort(defaultOreRegexpList);
            defaultOreRegexpNames = defaultOreRegexpList.toArray(new String[defaultOreRegexpList.size()]);
            backpackConf = config.get("backpacks." + backpackUid, "ore.dict.rejected", defaultOreRegexpNames);
            backpackConf.setComment(Translator.translateToLocalFormatted("for.config.backpacks.ore.dict.format", backpackUid));
            for (String name : OreDictionary.getOreNames()) {
                if (name == null) {
                    Log.error("Found a null oreName in the ore dictionary", new Object[0]);
                    continue;
                }
                for (String regex : backpackConf.getStringList()) {
                    if (!name.matches(regex)) continue;
                    backpackFilter.rejectOreDictName(name);
                }
            }
        }
    }

    public static void registerCrate(ItemCrated crate) {
        crates.add(crate);
    }

    public static void createCrateRecipes() {
        for (ItemCrated crate : crates) {
            ItemStack crateStack = new ItemStack((Item)crate);
            ItemStack uncrated = crate.getContained();
            if (uncrated == null) continue;
            if (crate.getOreDictName() != null) {
                PluginStorage.addCrating(crateStack, crate.getOreDictName());
            } else {
                PluginStorage.addCrating(crateStack, uncrated);
            }
            PluginStorage.addUncrating(crateStack, uncrated);
        }
    }

    private static void addCrating(@Nonnull ItemStack crateStack, @Nonnull Object uncrated) {
        FluidStack water = new FluidStack(FluidRegistry.WATER, 100);
        ItemStack box = PluginStorage.items.crate.getItemStack();
        RecipeManagers.carpenterManager.addRecipe(5, water, box, crateStack, "###", "###", "###", Character.valueOf('#'), uncrated);
    }

    private static void addUncrating(@Nonnull ItemStack crateStack, @Nonnull ItemStack uncrated) {
        ItemStack product = new ItemStack(uncrated.func_77973_b(), 9, uncrated.func_77952_i());
        RecipeManagers.carpenterManager.addRecipe(5, null, product, "#", Character.valueOf('#'), crateStack);
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-backpack-items")) {
            String[] tokens = message.getStringValue().split("@");
            if (tokens.length != 2) {
                IMCUtil.logInvalidIMCMessage(message);
                return true;
            }
            IBackpackDefinition backpackDefinition = BackpackManager.backpackInterface.getBackpackDefinition(tokens[0]);
            if (backpackDefinition == null) {
                String errorMessage = IMCUtil.getInvalidIMCMessageText(message);
                Log.warning("{} For non-existent backpack {}.", errorMessage, tokens[0]);
                return true;
            }
            List<ItemStack> itemStacks = ItemStackUtil.parseItemStackStrings(tokens[1], 0);
            Predicate<ItemStack> filter = backpackDefinition.getFilter();
            if (filter instanceof IBackpackFilterConfigurable) {
                IBackpackFilterConfigurable backpackFilter = (IBackpackFilterConfigurable)filter;
                for (ItemStack itemStack : itemStacks) {
                    backpackFilter.acceptItem(itemStack);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerStorage();
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return new ResupplyHandler();
    }

    @Override
    public void registerRecipes() {
        BlockRegistryApiculture beeBlocks = PluginApiculture.blocks;
        if (PluginStorage.items.apiaristBackpack != null && beeBlocks != null) {
            PluginStorage.addBackpackRecipe(PluginStorage.items.apiaristBackpack, "stickWood", beeBlocks.beeChest);
        }
        BlockRegistryLepidopterology butterflyBlocks = PluginLepidopterology.blocks;
        if (PluginStorage.items.lepidopteristBackpack != null && butterflyBlocks != null) {
            ItemStack chest = new ItemStack((Block)butterflyBlocks.butterflyChest);
            PluginStorage.addBackpackRecipe(PluginStorage.items.lepidopteristBackpack, "stickWood", chest);
        }
        PluginStorage.addBackpackRecipe(PluginStorage.items.minerBackpack, "ingotIron");
        PluginStorage.addBackpackRecipe(PluginStorage.items.diggerBackpack, "stone");
        PluginStorage.addBackpackRecipe(PluginStorage.items.foresterBackpack, "logWood");
        PluginStorage.addBackpackRecipe(PluginStorage.items.hunterBackpack, Items.field_151008_G);
        PluginStorage.addBackpackRecipe(PluginStorage.items.adventurerBackpack, Items.field_151103_aS);
        PluginStorage.addBackpackRecipe(PluginStorage.items.builderBackpack, Items.field_151119_aD);
        if (ForestryAPI.enabledPlugins.contains("forestry.factory")) {
            RecipeManagers.carpenterManager.addRecipe(20, new FluidStack(FluidRegistry.WATER, 1000), null, PluginStorage.items.crate.getItemStack(24), " # ", "# #", " # ", Character.valueOf('#'), "logWood");
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.minerBackpack, PluginStorage.items.minerBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.diggerBackpack, PluginStorage.items.diggerBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.foresterBackpack, PluginStorage.items.foresterBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.hunterBackpack, PluginStorage.items.hunterBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.adventurerBackpack, PluginStorage.items.adventurerBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.builderBackpack, PluginStorage.items.builderBackpackT2);
        }
    }

    private static void addBackpackRecipe(Item backpack, Object material) {
        PluginStorage.addBackpackRecipe(backpack, material, "chestWood");
    }

    private static void addBackpackRecipe(Item backpack, Object material, Object chest) {
        RecipeUtil.addRecipe(backpack, "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), material, Character.valueOf('Y'), chest);
    }

    private static void addT2BackpackRecipe(Item backpackT1, Item backpackT2) {
        ItemStack wovenSilk = PluginCore.items.craftingMaterial.getWovenSilk();
        RecipeManagers.carpenterManager.addRecipe(200, new FluidStack(FluidRegistry.WATER, 1000), null, new ItemStack(backpackT2), "WXW", "WTW", "WWW", Character.valueOf('X'), "gemDiamond", Character.valueOf('W'), wovenSilk, Character.valueOf('T'), backpackT1);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBakeModel(ModelBakeEvent event) {
        ModelCrate.initModel(event);
    }

    @Override
    public void addLootPoolNames(Set<String> lootPoolNames) {
        super.addLootPoolNames(lootPoolNames);
        lootPoolNames.add("forestry_storage_items");
    }

    static {
        crates = new ArrayList<ItemCrated>();
    }
}

