/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.client.render.IModelRegister;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileSpecialFlower;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class BlockSpecialFlower
extends BlockFlower
implements ISpecialFlower,
IWandable,
ILexiconable,
IWandHUD,
IModelRegister {
    private static final AxisAlignedBB AABB;

    protected BlockSpecialFlower() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE).func_177226_a((IProperty)this.field_176496_a, (Comparable)BlockFlower.EnumFlowerType.POPPY));
        this.setRegistryName(new ResourceLocation("Botania", "specialFlower"));
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockSpecialFlower((Block)this), (ResourceLocation)this.getRegistryName());
        this.func_149663_c("specialFlower");
        this.func_149711_c(0.1f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(false);
        this.func_149647_a(BotaniaCreativeTab.INSTANCE);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{this.func_176494_l(), BotaniaStateProps.COLOR}, new IUnlistedProperty[]{BotaniaStateProps.SUBTILE_ID});
    }

    @Nonnull
    public IExtendedBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileSpecialFlower && ((TileSpecialFlower)te).getSubTile() != null) {
            Class<?> clazz = ((TileSpecialFlower)te).getSubTile().getClass();
            String id = BotaniaAPI.getSubTileStringMapping(clazz);
            return ((IExtendedBlockState)state).withProperty(BotaniaStateProps.SUBTILE_ID, (Object)id);
        }
        return (IExtendedBlockState)state;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176765_a();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta > 15) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return world.func_180495_p(pos).getLightValue(world, pos);
        }
        return world.func_175625_s(pos) == null ? 0 : ((TileSpecialFlower)world.func_175625_s(pos)).getLightValue();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getComparatorInputOverride();
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getPowerLevel(side);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull Item item, CreativeTabs tab, @Nonnull List<ItemStack> stacks) {
        for (String s : BotaniaAPI.subtilesForCreativeMenu) {
            stacks.add(ItemBlockSpecialFlower.ofType(s));
            if (!BotaniaAPI.miniFlowers.containsKey((Object)s)) continue;
            stacks.add(ItemBlockSpecialFlower.ofType((String)BotaniaAPI.miniFlowers.get((Object)s)));
        }
    }

    @Nonnull
    public BlockFlower.EnumFlowerColor func_176495_j() {
        return BlockFlower.EnumFlowerColor.RED;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        String name = ((TileSpecialFlower)world.func_175625_s((BlockPos)pos)).subTileName;
        return ItemBlockSpecialFlower.ofType(name);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.redStringRelay || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150391_bh || super.func_176196_c(world, pos);
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == ModBlocks.redStringRelay || state.func_177230_c() == Blocks.field_150391_bh || super.func_185514_i(state);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockHarvested(world, pos, state, player);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            this.func_176208_a(world, pos, state, player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            String name = ((TileSpecialFlower)tile).subTileName;
            list.add(ItemBlockSpecialFlower.ofType(name));
            ((TileSpecialFlower)tile).getDrops(list);
        }
        return list;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int par5, int par6) {
        super.func_189539_a(state, world, pos, par5, par6);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null ? tileentity.func_145842_c(par5, par6) : false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileSpecialFlower();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getEntry();
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).onWanded(stack, player);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockPlacedBy(world, pos, state, entity, stack);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockAdded(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (stack != null && stack.func_77973_b() == ModItems.dye) {
            EnumDyeColor oldColor;
            EnumDyeColor newColor = EnumDyeColor.func_176764_b((int)stack.func_77952_i());
            if (newColor != (oldColor = (EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR))) {
                world.func_180501_a(pos, state.func_177226_a(BotaniaStateProps.COLOR, (Comparable)newColor), 3);
            }
            return true;
        }
        return ((TileSpecialFlower)world.func_175625_s(pos)).onBlockActivated(world, pos, state, player, hand, stack, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TileSpecialFlower)world.func_175625_s(pos)).renderHUD(mc, res);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178442_a(new IProperty[]{this.func_176494_l()}).func_178441_a());
        ModelHandler.registerInventoryVariant((Block)this);
    }

    static {
        BotaniaAPI.subtilesForCreativeMenu.addAll(Arrays.asList("puredaisy", "manastar", "endoflame", "hydroangeas", "thermalily", "arcanerose", "munchdew", "entropinnyum", "kekimurus", "gourmaryllis", "narslimmus", "spectrolus", "rafflowsia", "dandelifeon", "jadedAmaranthus", "bellethorn", "dreadthorn", "heiseiDream", "tigerseye", "marimorphosis", "orechid", "orechidIgnem", "fallenKanade", "exoflame", "agricarnation", "hopperhock", "rannuncarpus", "tangleberrie", "jiyuulia", "hyacidus", "medumone", "pollidisiac", "clayconia", "loonium", "daffomill", "vinculotus", "spectranthemum", "bubbell", "solegnolia", "bergamute"));
        AABB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.8, 1.0, 0.8);
    }
}

