/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.component.FlowerComponent;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class TileEnchanter
extends TileMod
implements ISparkAttachable {
    private static final String TAG_STAGE = "stage";
    private static final String TAG_STAGE_TICKS = "stageTicks";
    private static final String TAG_STAGE_3_END_TICKS = "stage3EndTicks";
    private static final String TAG_MANA_REQUIRED = "manaRequired";
    private static final String TAG_MANA = "mana";
    private static final String TAG_ITEM = "item";
    private static final String TAG_ENCHANTS = "enchantsToApply";
    public State stage = State.IDLE;
    public int stageTicks = 0;
    public int stage3EndTicks = 0;
    private int manaRequired = -1;
    private int mana = 0;
    public ItemStack itemToEnchant = null;
    private final List<EnchantmentData> enchants = new ArrayList<EnchantmentData>();
    private static final BlockPos[] OBSIDIAN_LOCATIONS = new BlockPos[]{new BlockPos(0, -1, 0), new BlockPos(0, -1, 1), new BlockPos(0, -1, -1), new BlockPos(1, -1, 0), new BlockPos(-1, -1, 0), new BlockPos(0, -1, 2), new BlockPos(-1, -1, 2), new BlockPos(1, -1, 2), new BlockPos(0, -1, -2), new BlockPos(-1, -1, -2), new BlockPos(1, -1, -2), new BlockPos(2, -1, 0), new BlockPos(2, -1, 1), new BlockPos(2, -1, -1), new BlockPos(-2, -1, 0), new BlockPos(-2, -1, 1), new BlockPos(-2, -1, -1)};
    private static final Map<EnumFacing.Axis, BlockPos[]> PYLON_LOCATIONS = new EnumMap<EnumFacing.Axis, BlockPos[]>(EnumFacing.Axis.class);
    private static final BlockPos[] FLOWER_LOCATIONS;

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        for (BlockPos o : OBSIDIAN_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), Blocks.field_150343_Z.func_176223_P());
        }
        for (BlockPos p : PYLON_LOCATIONS.get(EnumFacing.Axis.X)) {
            mb.addComponent(p.func_177984_a(), ModBlocks.pylon.func_176223_P());
            mb.addComponent(new FlowerComponent(p, ModBlocks.flower));
        }
        for (BlockPos f : FLOWER_LOCATIONS) {
            mb.addComponent(new FlowerComponent(f.func_177984_a(), ModBlocks.flower));
        }
        mb.addComponent(BlockPos.field_177992_a.func_177984_a(), Blocks.field_150368_y.func_176223_P());
        return mb.makeSet();
    }

    public void onWanded(EntityPlayer player, ItemStack wand) {
        if (this.stage != State.IDLE || this.itemToEnchant == null || !this.itemToEnchant.func_77956_u()) {
            return;
        }
        List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 3), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 3)));
        int count = items.size();
        if (count > 0 && !this.field_145850_b.field_72995_K) {
            for (EntityItem entity : items) {
                NBTTagCompound enchant;
                short id;
                NBTTagList enchants;
                ItemStack item = entity.func_92059_d();
                if (item.func_77973_b() != Items.field_151134_bR || (enchants = Items.field_151134_bR.func_92110_g(item)) == null || enchants.func_74745_c() <= 0 || !this.isEnchantmentValid(Enchantment.func_185262_c((int)(id = (enchant = enchants.func_150305_b(0)).func_74765_d("id"))))) continue;
                this.advanceStage();
                return;
            }
        }
    }

    @Override
    public void func_73660_a() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(BotaniaStateProps.ENCHANTER_DIRECTION);
        BlockPos[] blockPosArray = PYLON_LOCATIONS.get(axis);
        int n = blockPosArray.length;
        for (int i = 0; i < n; ++i) {
            BlockPos blockPos = blockPosArray[i];
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)blockPos));
            if (tile == null || !(tile instanceof TilePylon)) continue;
            boolean bl = ((TilePylon)tile).activated = this.stage == State.GATHER_MANA;
            if (this.stage != State.GATHER_MANA) continue;
            ((TilePylon)tile).centerPos = this.field_174879_c;
        }
        if (this.stage != State.IDLE) {
            ++this.stageTicks;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!TileEnchanter.canEnchanterExist(this.field_145850_b, this.field_174879_c, axis)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150368_y.func_176223_P(), 3);
            PacketHandler.sendToNearby(this.field_145850_b, this.field_174879_c, (IMessage)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.ENCHANTER_DESTROY, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, new int[0]));
            this.field_145850_b.func_184133_a(null, this.field_174879_c, BotaniaSoundEvents.enchanterFade, SoundCategory.BLOCKS, 0.5f, 10.0f);
        }
        switch (this.stage) {
            case GATHER_ENCHANTS: {
                if (this.stageTicks % 20 != 0) break;
                List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 3), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 3)));
                int count = items.size();
                boolean addedEnch = false;
                if (count > 0 && !this.field_145850_b.field_72995_K) {
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        NBTTagList enchants;
                        EntityItem entity = (EntityItem)iterator.next();
                        ItemStack item = entity.func_92059_d();
                        if (item.func_77973_b() != Items.field_151134_bR || (enchants = Items.field_151134_bR.func_92110_g(item)) == null || enchants.func_74745_c() <= 0) continue;
                        NBTTagCompound enchant = enchants.func_150305_b(0);
                        short enchantId = enchant.func_74765_d("id");
                        short enchantLvl = enchant.func_74765_d("lvl");
                        Enchantment ench = Enchantment.func_185262_c((int)enchantId);
                        if (this.hasEnchantAlready(ench) || !this.isEnchantmentValid(ench)) continue;
                        this.enchants.add(new EnchantmentData(ench, (int)enchantLvl));
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, BotaniaSoundEvents.ding, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        addedEnch = true;
                        break;
                    }
                }
                if (addedEnch) break;
                if (this.enchants.isEmpty()) {
                    this.stage = State.IDLE;
                    break;
                }
                this.advanceStage();
                break;
            }
            case GATHER_MANA: {
                if (this.manaRequired == -1) {
                    this.manaRequired = 0;
                    for (EnchantmentData data : this.enchants) {
                        this.manaRequired += (int)(5000.0f * ((float)(15 - Math.min(15, data.field_76302_b.func_77324_c().func_185270_a())) * 1.05f) * ((3.0f + (float)(data.field_76303_c * data.field_76303_c)) * 0.25f) * (0.9f + (float)this.enchants.size() * 0.05f) * (data.field_76302_b.func_185261_e() ? 1.25f : 1.0f));
                    }
                    break;
                }
                if (this.mana >= this.manaRequired) {
                    this.manaRequired = 0;
                    for (BlockPos blockPos : PYLON_LOCATIONS.get(axis)) {
                        ((TilePylon)this.field_145850_b.func_175625_s((BlockPos)this.field_174879_c.func_177971_a((Vec3i)blockPos))).activated = false;
                    }
                    this.advanceStage();
                    break;
                }
                ISparkEntity spark = this.getAttachedSpark();
                if (spark != null) {
                    List<ISparkEntity> sparkEntities = SparkHelper.getSparksAround(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                    for (ISparkEntity iSparkEntity : sparkEntities) {
                        if (spark == iSparkEntity || iSparkEntity.getAttachedTile() == null || !(iSparkEntity.getAttachedTile() instanceof IManaPool)) continue;
                        iSparkEntity.registerTransfer(spark);
                    }
                }
                if (this.stageTicks % 5 != 0) break;
                this.sync();
                break;
            }
            case DO_ENCHANT: {
                if (this.stageTicks < 100) break;
                for (EnchantmentData data : this.enchants) {
                    if (EnchantmentHelper.func_77506_a((Enchantment)data.field_76302_b, (ItemStack)this.itemToEnchant) != 0) continue;
                    this.itemToEnchant.func_77966_a(data.field_76302_b, data.field_76303_c);
                }
                this.enchants.clear();
                this.manaRequired = -1;
                this.mana = 0;
                this.craftingFanciness();
                this.advanceStage();
                break;
            }
            case RESET: {
                if (this.stageTicks < 20) break;
                this.advanceStage();
                break;
            }
        }
    }

    private void advanceStage() {
        switch (this.stage) {
            case IDLE: {
                this.stage = State.GATHER_ENCHANTS;
                break;
            }
            case GATHER_ENCHANTS: {
                this.stage = State.GATHER_MANA;
                break;
            }
            case GATHER_MANA: {
                this.stage = State.DO_ENCHANT;
                break;
            }
            case DO_ENCHANT: {
                this.stage = State.RESET;
                this.stage3EndTicks = this.stageTicks;
                break;
            }
            case RESET: {
                this.stage = State.IDLE;
                this.stage3EndTicks = 0;
            }
        }
        this.stageTicks = 0;
        this.sync();
    }

    private void craftingFanciness() {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, BotaniaSoundEvents.enchanterEnchant, SoundCategory.BLOCKS, 1.0f, 1.0f);
        PacketHandler.sendToNearby(this.field_145850_b, this.field_174879_c, (IMessage)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.ENCHANTER_CRAFT, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, new int[0]));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.manaRequired;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.min(this.manaRequired, this.mana + mana);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return this.manaRequired > 0;
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74768_a(TAG_MANA_REQUIRED, this.manaRequired);
        cmp.func_74768_a(TAG_STAGE, this.stage.ordinal());
        cmp.func_74768_a(TAG_STAGE_TICKS, this.stageTicks);
        cmp.func_74768_a(TAG_STAGE_3_END_TICKS, this.stage3EndTicks);
        NBTTagCompound itemCmp = new NBTTagCompound();
        if (this.itemToEnchant != null) {
            this.itemToEnchant.func_77955_b(itemCmp);
        }
        cmp.func_74782_a(TAG_ITEM, (NBTBase)itemCmp);
        String enchStr = this.enchants.stream().map(e -> Enchantment.field_185264_b.func_177774_c((Object)e.field_76302_b) + "=" + e.field_76303_c).collect(Collectors.joining(","));
        cmp.func_74778_a(TAG_ENCHANTS, enchStr);
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.manaRequired = cmp.func_74762_e(TAG_MANA_REQUIRED);
        this.stage = State.values()[cmp.func_74762_e(TAG_STAGE)];
        this.stageTicks = cmp.func_74762_e(TAG_STAGE_TICKS);
        this.stage3EndTicks = cmp.func_74762_e(TAG_STAGE_3_END_TICKS);
        NBTTagCompound itemCmp = cmp.func_74775_l(TAG_ITEM);
        this.itemToEnchant = ItemStack.func_77949_a((NBTTagCompound)itemCmp);
        this.enchants.clear();
        String enchStr = cmp.func_74779_i(TAG_ENCHANTS);
        if (!enchStr.isEmpty()) {
            String[] enchTokens;
            for (String token : enchTokens = enchStr.split(",")) {
                String[] entryTokens = token.split("=");
                Enchantment ench = Enchantment.func_180305_b((String)entryTokens[0]);
                int lvl = Integer.parseInt(entryTokens[1]);
                this.enchants.add(new EnchantmentData(ench, lvl));
            }
        }
    }

    private boolean hasEnchantAlready(Enchantment enchant) {
        for (EnchantmentData data : this.enchants) {
            if (data.field_76302_b != enchant) continue;
            return true;
        }
        return false;
    }

    private boolean isEnchantmentValid(Enchantment ench) {
        if (!ench.func_92089_a(this.itemToEnchant)) {
            return false;
        }
        for (EnchantmentData data : this.enchants) {
            Enchantment otherEnch = data.field_76302_b;
            if (otherEnch.func_77326_a(ench) && ench.func_77326_a(otherEnch)) continue;
            return false;
        }
        return true;
    }

    public static boolean canEnchanterExist(World world, BlockPos pos, EnumFacing.Axis axis) {
        for (BlockPos obsidian : OBSIDIAN_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)obsidian)).func_177230_c() == Blocks.field_150343_Z) continue;
            return false;
        }
        for (BlockPos pylon : PYLON_LOCATIONS.get(axis)) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)pylon)).func_177230_c() == ModBlocks.pylon && BotaniaAPI.internalHandler.isBotaniaFlower(world, pos.func_177971_a((Vec3i)pylon).func_177977_b())) continue;
            return false;
        }
        for (BlockPos flower : FLOWER_LOCATIONS) {
            if (BotaniaAPI.internalHandler.isBotaniaFlower(world, pos.func_177971_a((Vec3i)flower))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public void attachSpark(ISparkEntity entity) {
    }

    @Override
    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return this.stage == State.DO_ENCHANT;
    }

    @Override
    public int getAvailableSpaceForMana() {
        return Math.max(0, this.manaRequired - this.getCurrentMana());
    }

    public void renderHUD(ScaledResolution res) {
        if (this.manaRequired > 0 && this.itemToEnchant != null) {
            int x = res.func_78326_a() / 2 + 20;
            int y = res.func_78328_b() / 2 - 8;
            RenderHelper.renderProgressPie(x, y, (float)this.mana / (float)this.manaRequired, this.itemToEnchant);
        }
    }

    static {
        PYLON_LOCATIONS.put(EnumFacing.Axis.X, new BlockPos[]{new BlockPos(-5, 1, 0), new BlockPos(5, 1, 0), new BlockPos(-4, 1, 3), new BlockPos(4, 1, 3), new BlockPos(-4, 1, -3), new BlockPos(4, 1, -3)});
        PYLON_LOCATIONS.put(EnumFacing.Axis.Z, new BlockPos[]{new BlockPos(0, 1, -5), new BlockPos(0, 1, 5), new BlockPos(3, 1, -4), new BlockPos(3, 1, 4), new BlockPos(-3, 1, -4), new BlockPos(-3, 1, 4)});
        FLOWER_LOCATIONS = new BlockPos[]{new BlockPos(-1, 0, -1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(1, 0, 1)};
    }

    public static enum State {
        IDLE,
        GATHER_ENCHANTS,
        GATHER_MANA,
        DO_ENCHANT,
        RESET;

    }
}

