/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import com.google.common.base.Predicates;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IManaDissolvable;
import vazkii.botania.api.mana.IKeyLocked;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IThrottledPacket;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.TileBellows;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.core.handler.MethodHandles;
import vazkii.botania.common.item.ItemManaTablet;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class TilePool
extends TileMod
implements IManaPool,
IKeyLocked,
ISparkAttachable,
IThrottledPacket {
    public static final Color PARTICLE_COLOR = new Color(50943);
    public static final int MAX_MANA = 1000000;
    public static final int MAX_MANA_DILLUTED = 10000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_KNOWN_MANA = "knownMana";
    private static final String TAG_OUTPUTTING = "outputting";
    private static final String TAG_COLOR = "color";
    private static final String TAG_MANA_CAP = "manaCap";
    private static final String TAG_CAN_ACCEPT = "canAccept";
    private static final String TAG_CAN_SPARE = "canSpare";
    private static final String TAG_FRAGILE = "fragile";
    private static final String TAG_INPUT_KEY = "inputKey";
    private static final String TAG_OUTPUT_KEY = "outputKey";
    private boolean outputting = false;
    public EnumDyeColor color = EnumDyeColor.WHITE;
    int mana;
    private int knownMana = -1;
    public int manaCap = -1;
    private int soundTicks = 0;
    private boolean canAccept = true;
    private boolean canSpare = true;
    public boolean fragile = false;
    boolean isDoingTransfer = false;
    int ticksDoingTransfer = 0;
    private String inputKey = "";
    private final String outputKey = "";
    private int ticks = 0;
    private boolean sendPacket = false;

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            return true;
        }
        if (oldState.func_177230_c() != ModBlocks.pool || newState.func_177230_c() != ModBlocks.pool) {
            return true;
        }
        return oldState.func_177229_b(BotaniaStateProps.POOL_VARIANT) != newState.func_177229_b(BotaniaStateProps.POOL_VARIANT);
    }

    @Override
    public boolean isFull() {
        Block blockBelow = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c();
        return blockBelow != ModBlocks.manaVoid && this.getCurrentMana() >= this.manaCap;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + mana, this.manaCap));
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        this.markDispatchable();
    }

    public void func_145843_s() {
        super.func_145843_s();
        ManaNetworkEvent.removePool(this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.func_145843_s();
    }

    public static RecipeManaInfusion getMatchingRecipe(@Nonnull ItemStack stack, @Nonnull IBlockState state) {
        ArrayList<RecipeManaInfusion> matchingNonCatRecipes = new ArrayList<RecipeManaInfusion>();
        ArrayList<RecipeManaInfusion> matchingCatRecipes = new ArrayList<RecipeManaInfusion>();
        for (RecipeManaInfusion recipe : BotaniaAPI.manaInfusionRecipes) {
            if (!recipe.matches(stack)) continue;
            if (recipe.getCatalyst() == null) {
                matchingNonCatRecipes.add(recipe);
                continue;
            }
            if (recipe.getCatalyst() != state) continue;
            matchingCatRecipes.add(recipe);
        }
        return !matchingCatRecipes.isEmpty() ? (RecipeManaInfusion)matchingCatRecipes.get(0) : (!matchingNonCatRecipes.isEmpty() ? (RecipeManaInfusion)matchingNonCatRecipes.get(0) : null);
    }

    public boolean collideEntityItem(EntityItem item) {
        int age;
        if (this.field_145850_b.field_72995_K || item.field_70128_L) {
            return false;
        }
        ItemStack stack = item.func_92059_d();
        if (stack.func_77973_b() instanceof IManaDissolvable) {
            ((IManaDissolvable)stack.func_77973_b()).onDissolveTick(this, stack, item);
            if (stack.field_77994_a == 0) {
                item.func_70106_y();
            }
        }
        try {
            age = MethodHandles.itemAge_getter.invokeExact(item);
        }
        catch (Throwable throwable) {
            return false;
        }
        if (age > 100 && age < 130) {
            return false;
        }
        RecipeManaInfusion recipe = TilePool.getMatchingRecipe(stack, this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()));
        if (recipe != null) {
            int mana = recipe.getManaToConsume();
            if (this.getCurrentMana() >= mana) {
                this.recieveMana(-mana);
                --stack.field_77994_a;
                if (stack.field_77994_a == 0) {
                    item.func_70106_y();
                }
                ItemStack output = recipe.getOutput().func_77946_l();
                EntityItem outputItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                try {
                    MethodHandles.itemAge_setter.invokeExact(outputItem, 105);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.field_145850_b.func_72838_d((Entity)outputItem);
                this.craftingFanciness();
                return true;
            }
        }
        return false;
    }

    private void craftingFanciness() {
        if (this.soundTicks == 0) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, BotaniaSoundEvents.manaPoolCraft, SoundCategory.BLOCKS, 0.4f, 4.0f);
            this.soundTicks = 6;
        }
        PacketHandler.sendToNearby(this.field_145850_b, this.func_174877_v(), (IMessage)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.POOL_CRAFT, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), new int[0]));
    }

    @Override
    public void func_73660_a() {
        if (this.manaCap == -1) {
            int n = this.manaCap = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BotaniaStateProps.POOL_VARIANT) == PoolVariant.DILUTED ? 10000 : 1000000;
        }
        if (!ManaNetworkHandler.instance.isPoolIn(this) && !this.func_145837_r()) {
            ManaNetworkEvent.addPool(this);
        }
        if (this.field_145850_b.field_72995_K) {
            double particleChance = 1.0 - (double)this.getCurrentMana() / (double)this.manaCap * 0.1;
            if (Math.random() > particleChance) {
                Botania.proxy.wispFX((double)this.field_174879_c.func_177958_n() + 0.3 + Math.random() * 0.5, (double)this.field_174879_c.func_177956_o() + 0.6 + Math.random() * 0.25, (double)this.field_174879_c.func_177952_p() + Math.random(), (float)PARTICLE_COLOR.getRed() / 255.0f, (float)PARTICLE_COLOR.getGreen() / 255.0f, (float)PARTICLE_COLOR.getBlue() / 255.0f, (float)Math.random() / 3.0f, (float)(-Math.random()) / 25.0f, 2.0f);
            }
            return;
        }
        boolean wasDoingTransfer = this.isDoingTransfer;
        this.isDoingTransfer = false;
        if (this.soundTicks > 0) {
            --this.soundTicks;
        }
        if (this.sendPacket && this.ticks % 10 == 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            this.sendPacket = false;
        }
        List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)));
        for (EntityItem item : items) {
            int manaVal;
            ItemStack stack;
            if (item.field_70128_L || (stack = item.func_92059_d()) == null || !(stack.func_77973_b() instanceof IManaItem)) continue;
            IManaItem mana = (IManaItem)stack.func_77973_b();
            if ((!this.outputting || !mana.canReceiveManaFromPool(stack, this)) && (this.outputting || !mana.canExportManaToPool(stack, this))) continue;
            boolean didSomething = false;
            int bellowCount = 0;
            if (this.outputting) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
                    if (tile == null || !(tile instanceof TileBellows) || ((TileBellows)tile).getLinkedTile() != this) continue;
                    ++bellowCount;
                }
            }
            int transfRate = 1000 * (bellowCount + 1);
            if (this.outputting) {
                if (this.canSpare) {
                    if (this.getCurrentMana() > 0 && mana.getMana(stack) < mana.getMaxMana(stack)) {
                        didSomething = true;
                    }
                    manaVal = Math.min(transfRate, Math.min(this.getCurrentMana(), mana.getMaxMana(stack) - mana.getMana(stack)));
                    mana.addMana(stack, manaVal);
                    this.recieveMana(-manaVal);
                }
            } else if (this.canAccept) {
                if (mana.getMana(stack) > 0 && !this.isFull()) {
                    didSomething = true;
                }
                manaVal = Math.min(transfRate, Math.min(this.manaCap - this.getCurrentMana(), mana.getMana(stack)));
                mana.addMana(stack, -manaVal);
                this.recieveMana(manaVal);
            }
            if (!didSomething) continue;
            if (ConfigHandler.chargingAnimationEnabled && this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                PacketHandler.sendToNearby(this.field_145850_b, this.func_174877_v(), (IMessage)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.POOL_CHARGE, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), this.outputting ? 1 : 0));
            }
            this.isDoingTransfer = this.outputting;
        }
        if (this.isDoingTransfer) {
            ++this.ticksDoingTransfer;
        } else {
            this.ticksDoingTransfer = 0;
            if (wasDoingTransfer) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
        ++this.ticks;
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74757_a(TAG_OUTPUTTING, this.outputting);
        cmp.func_74768_a(TAG_COLOR, this.color.func_176765_a());
        cmp.func_74768_a(TAG_MANA_CAP, this.manaCap);
        cmp.func_74757_a(TAG_CAN_ACCEPT, this.canAccept);
        cmp.func_74757_a(TAG_CAN_SPARE, this.canSpare);
        cmp.func_74757_a(TAG_FRAGILE, this.fragile);
        cmp.func_74778_a(TAG_INPUT_KEY, this.inputKey);
        cmp.func_74778_a(TAG_OUTPUT_KEY, "");
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.outputting = cmp.func_74767_n(TAG_OUTPUTTING);
        this.color = EnumDyeColor.func_176764_b((int)cmp.func_74762_e(TAG_COLOR));
        if (cmp.func_74764_b(TAG_MANA_CAP)) {
            this.manaCap = cmp.func_74762_e(TAG_MANA_CAP);
        }
        if (cmp.func_74764_b(TAG_CAN_ACCEPT)) {
            this.canAccept = cmp.func_74767_n(TAG_CAN_ACCEPT);
        }
        if (cmp.func_74764_b(TAG_CAN_SPARE)) {
            this.canSpare = cmp.func_74767_n(TAG_CAN_SPARE);
        }
        this.fragile = cmp.func_74767_n(TAG_FRAGILE);
        if (cmp.func_74764_b(TAG_INPUT_KEY)) {
            this.inputKey = cmp.func_74779_i(TAG_INPUT_KEY);
        }
        if (cmp.func_74764_b(TAG_OUTPUT_KEY)) {
            this.inputKey = cmp.func_74779_i(TAG_OUTPUT_KEY);
        }
        if (cmp.func_74764_b(TAG_KNOWN_MANA)) {
            this.knownMana = cmp.func_74762_e(TAG_KNOWN_MANA);
        }
    }

    public void onWanded(EntityPlayer player, ItemStack wand) {
        if (player == null) {
            return;
        }
        if (player.func_70093_af()) {
            this.outputting = !this.outputting;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
        }
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.writePacketNBT(nbttagcompound);
            nbttagcompound.func_74768_a(TAG_KNOWN_MANA, this.getCurrentMana());
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketUpdateTileEntity(this.field_174879_c, -999, nbttagcompound));
            }
        }
        this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, BotaniaSoundEvents.ding, SoundCategory.PLAYERS, 0.11f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        ItemStack pool = new ItemStack(ModBlocks.pool, 1, ((PoolVariant)((Object)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BotaniaStateProps.POOL_VARIANT))).ordinal());
        String name = I18n.func_135052_a((String)(pool.func_77977_a().replaceAll("tile.", "tile.botania:") + ".name"), (Object[])new Object[0]);
        int color = 0x4444FF;
        HUDHandler.drawSimpleManaHUD(color, this.knownMana, this.manaCap, name, res);
        int x = res.func_78326_a() / 2 - 11;
        int y = res.func_78328_b() / 2 + 30;
        int u = this.outputting ? 22 : 0;
        int v = 38;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        mc.field_71446_o.func_110577_a(HUDHandler.manaBar);
        RenderHelper.drawTexturedModalRect(x, y, 0.0f, u, v, 22, 15);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack tablet = new ItemStack(ModItems.manaTablet);
        ItemManaTablet.setStackCreative(tablet);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        mc.func_175599_af().func_180450_b(tablet, x - 20, y);
        mc.func_175599_af().func_180450_b(pool, x + 26, y);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @Override
    public boolean isOutputtingPower() {
        return this.outputting;
    }

    @Override
    public int getCurrentMana() {
        IBlockState state;
        if (this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177228_b().containsKey(BotaniaStateProps.POOL_VARIANT)) {
            return state.func_177229_b(BotaniaStateProps.POOL_VARIANT) == PoolVariant.CREATIVE ? 1000000 : this.mana;
        }
        return 0;
    }

    @Override
    public String getInputKey() {
        return this.inputKey;
    }

    @Override
    public String getOutputKey() {
        return "";
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public void attachSpark(ISparkEntity entity) {
    }

    @Override
    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return false;
    }

    @Override
    public int getAvailableSpaceForMana() {
        return Math.max(0, this.manaCap - this.getCurrentMana());
    }

    @Override
    public EnumDyeColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(EnumDyeColor color) {
        this.color = color;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 11);
    }

    @Override
    public void markDispatchable() {
        this.sendPacket = true;
    }
}

