/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileManaFlame;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.world.WorldTypeSkyblock;

public final class SkyblockWorldEvents {
    private static final String TAG_MADE_ISLAND = "Botania-MadeIsland";
    private static final String TAG_HAS_OWN_ISLAND = "Botania-HasOwnIsland";
    private static final String TAG_ISLAND_X = "Botania-IslandX";
    private static final String TAG_ISLAND_Y = "Botania-IslandY";
    private static final String TAG_ISLAND_Z = "Botania-IslandZ";

    private SkyblockWorldEvents() {
    }

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            NBTTagCompound data = player.getEntityData();
            if (!data.func_74764_b("PlayerPersisted")) {
                data.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
            }
            NBTTagCompound persist = data.func_74775_l("PlayerPersisted");
            if (player.field_70173_aa > 3 && !persist.func_74767_n(TAG_MADE_ISLAND)) {
                BlockPos coords;
                World world = player.field_70170_p;
                if (WorldTypeSkyblock.isWorldSkyblock(world) && world.func_180495_p((coords = world.func_175694_M()).func_177979_c(4)).func_177230_c() != Blocks.field_150357_h && world.field_73011_w.getDimension() == 0) {
                    SkyblockWorldEvents.spawnPlayer(player, coords, false);
                }
                persist.func_74757_a(TAG_MADE_ISLAND, true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (WorldTypeSkyblock.isWorldSkyblock(event.getWorld())) {
            RayTraceResult RayTraceResult2;
            ItemStack equipped = event.getItemStack();
            if (equipped == null && event.getEntityPlayer().func_70093_af()) {
                Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
                if (block == Blocks.field_150349_c || block == Blocks.field_150346_d) {
                    if (event.getWorld().field_72995_K) {
                        event.getEntityPlayer().func_184609_a(event.getHand());
                    } else {
                        event.getWorld().func_184133_a(null, event.getPos(), block.func_185467_w().func_185845_c(), SoundCategory.BLOCKS, block.func_185467_w().func_185843_a() * 0.4f, block.func_185467_w().func_185847_b() + (float)(Math.random() * 0.2 - 0.1));
                        if (Math.random() < 0.8) {
                            event.getEntityPlayer().func_71019_a(new ItemStack(ModItems.manaResource, 1, 21), false);
                        }
                    }
                }
            } else if (equipped != null && equipped.func_77973_b() == Items.field_151054_z && !event.getWorld().field_72995_K && (RayTraceResult2 = ToolCommons.raytraceFromEntity(event.getWorld(), (Entity)event.getEntityPlayer(), true, 4.5)) != null && RayTraceResult2.field_72313_a == RayTraceResult.Type.BLOCK && event.getWorld().func_180495_p(RayTraceResult2.func_178782_a()).func_185904_a() == Material.field_151586_h) {
                --equipped.field_77994_a;
                if (equipped.field_77994_a <= 0) {
                    event.getEntityPlayer().func_184611_a(event.getHand(), new ItemStack(ModItems.waterBowl));
                } else {
                    event.getEntityPlayer().func_71019_a(new ItemStack(ModItems.waterBowl), false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDrops(BlockEvent.HarvestDropsEvent event) {
        if (WorldTypeSkyblock.isWorldSkyblock(event.getWorld()) && event.getState().func_177230_c() == Blocks.field_150329_H) {
            ItemStack stackToRemove = null;
            for (ItemStack stack : event.getDrops()) {
                if (stack.func_77973_b() != Items.field_151014_N || event.getWorld().field_73012_v.nextInt(4) != 0) continue;
                stackToRemove = stack;
                break;
            }
            if (stackToRemove != null) {
                event.getDrops().remove(stackToRemove);
                event.getDrops().add(new ItemStack(event.getWorld().field_73012_v.nextBoolean() ? Items.field_151080_bb : Items.field_151081_bc));
            }
        }
    }

    public static void spawnPlayer(EntityPlayer player, BlockPos pos, boolean fabricated) {
        NBTTagCompound data = player.getEntityData();
        if (!data.func_74764_b("PlayerPersisted")) {
            data.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound persist = data.func_74775_l("PlayerPersisted");
        boolean test = false;
        if (!persist.func_74767_n(TAG_HAS_OWN_ISLAND)) {
            SkyblockWorldEvents.createSkyblock(player.field_70170_p, pos);
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP pmp = (EntityPlayerMP)player;
                pmp.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 0.5);
                pmp.setSpawnChunk(pos, true, player.field_70170_p.field_73011_w.getDimension());
                player.field_71071_by.func_70441_a(new ItemStack(ModItems.lexicon));
            }
            if (fabricated) {
                persist.func_74757_a(TAG_HAS_OWN_ISLAND, true);
                persist.func_74780_a(TAG_ISLAND_X, player.field_70165_t);
                persist.func_74780_a(TAG_ISLAND_Y, player.field_70163_u);
                persist.func_74780_a(TAG_ISLAND_Z, player.field_70161_v);
            }
        } else {
            double posX = persist.func_74769_h(TAG_ISLAND_X);
            double posY = persist.func_74769_h(TAG_ISLAND_Y);
            double posZ = persist.func_74769_h(TAG_ISLAND_Z);
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP pmp = (EntityPlayerMP)player;
                pmp.func_70634_a(posX, posY, posZ);
            }
        }
    }

    public static void createSkyblock(World world, BlockPos pos) {
        int[][] rootPositions;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 3; ++k) {
                    world.func_175656_a(pos.func_177982_a(-1 + i, -1 - j, -1 + k), j == 0 ? Blocks.field_150349_c.func_176223_P() : Blocks.field_150346_d.func_176223_P());
                }
            }
        }
        world.func_175656_a(pos.func_177982_a(-1, -2, 0), Blocks.field_150358_i.func_176223_P());
        world.func_175656_a(pos.func_177982_a(1, 2, 1), ModBlocks.manaFlame.func_176223_P());
        ((TileManaFlame)world.func_175625_s(pos.func_177982_a(1, 2, 1))).setColor(new Color(70 + world.field_73012_v.nextInt(185), 70 + world.field_73012_v.nextInt(185), 70 + world.field_73012_v.nextInt(185)).getRGB());
        for (int[] root : rootPositions = new int[][]{{-1, -3, -1}, {-2, -4, -1}, {-2, -4, -2}, {1, -4, -1}, {1, -5, -1}, {2, -5, -1}, {2, -6, 0}, {0, -4, 2}, {0, -5, 2}, {0, -5, 3}, {0, -6, 3}}) {
            world.func_175656_a(pos.func_177982_a(root[0], root[1], root[2]), ModBlocks.root.func_176223_P());
        }
        world.func_175656_a(pos.func_177979_c(4), Blocks.field_150357_h.func_176223_P());
    }
}

