/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;

public abstract class TileEntityImmersiveConnectable
extends TileEntityIEBase
implements IImmersiveConnectable {
    protected WireType limitType = null;

    protected boolean canTakeLV() {
        return false;
    }

    protected boolean canTakeMV() {
        return false;
    }

    protected boolean canTakeHV() {
        return false;
    }

    protected boolean isRelay() {
        return false;
    }

    @Override
    public void onEnergyPassthrough(int amount) {
    }

    @Override
    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return true;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return false;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.func_174877_v();
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (cableType == WireType.STEEL && !this.canTakeHV()) {
            return false;
        }
        if (cableType == WireType.ELECTRUM && !this.canTakeMV()) {
            return false;
        }
        if (cableType == WireType.COPPER && !this.canTakeLV()) {
            return false;
        }
        if (cableType == WireType.STRUCTURE_ROPE) {
            return false;
        }
        if (cableType == WireType.STRUCTURE_STEEL) {
            return false;
        }
        return this.limitType == null || this.isRelay() && this.limitType == cableType;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        this.limitType = cableType;
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return this.limitType;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type = connection != null ? connection.cableType : null;
        Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC(this));
        if (!(outputs != null && outputs.size() != 0 || type != this.limitType && type != null)) {
            this.limitType = null;
        }
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        this.writeConnsToNBT(nbttagcompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, nbttagcompound);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.func_145839_a(nbt);
        this.loadConnsFromNBT(nbt);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == -1 || id == 255) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        if (id == 254) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state instanceof IExtendedBlockState) {
                state = state.func_185899_b((IBlockAccess)this.field_145850_b, this.func_174877_v());
                state = state.func_177230_c().getExtendedState(state, (IBlockAccess)this.field_145850_b, this.func_174877_v());
                ImmersiveEngineering.proxy.removeStateFromSmartModelCache((IExtendedBlockState)state);
                ImmersiveEngineering.proxy.removeStateFromConnectionModelCache((IExtendedBlockState)state);
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        try {
            this.limitType = nbt.func_74764_b("limitType") ? ApiUtils.getWireTypeFromNBT(nbt, "limitType") : null;
            if (nbt.func_74764_b("connectionList")) {
                this.loadConnsFromNBT(nbt);
            }
        }
        catch (Exception e) {
            IELogger.error("TileEntityImmersiveConenctable encountered MASSIVE error reading NBT. You shoudl probably report this.");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        try {
            if (this.limitType != null) {
                nbt.func_74778_a("limitType", this.limitType.getUniqueName());
            }
            if (descPacket) {
                this.writeConnsToNBT(nbt);
            }
        }
        catch (Exception e) {
            IELogger.error("TileEntityImmersiveConenctable encountered MASSIVE error writing NBT. You should probably report this.");
        }
    }

    private void loadConnsFromNBT(NBTTagCompound nbt) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !Minecraft.func_71410_x().func_71356_B() && nbt != null) {
            NBTTagList connectionList = nbt.func_150295_c("connectionList", 10);
            ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(Utils.toCC(this), this.field_145850_b);
            for (int i = 0; i < connectionList.func_74745_c(); ++i) {
                NBTTagCompound conTag = connectionList.func_150305_b(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT(conTag);
                if (con != null) {
                    ImmersiveNetHandler.INSTANCE.addConnection(this.field_145850_b, Utils.toCC(this), con);
                    continue;
                }
                IELogger.error("CLIENT read connection as null");
            }
        }
    }

    private void writeConnsToNBT(NBTTagCompound nbt) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && nbt != null) {
            NBTTagList connectionList = new NBTTagList();
            Set<ImmersiveNetHandler.Connection> conL = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC(this));
            if (conL != null) {
                for (ImmersiveNetHandler.Connection con : conL) {
                    connectionList.func_74742_a((NBTBase)con.writeToNBT());
                }
            }
            nbt.func_74782_a("connectionList", (NBTBase)connectionList);
        }
    }

    public Set<ImmersiveNetHandler.Connection> genConnBlockstate() {
        Set<ImmersiveNetHandler.Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, this.field_174879_c);
        if (conns == null) {
            return ImmutableSet.of();
        }
        HashSet<ImmersiveNetHandler.Connection> ret = new HashSet<ImmersiveNetHandler.Connection>(){

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HashSet)) {
                    return false;
                }
                HashSet other = (HashSet)o;
                if (other.size() != this.size()) {
                    return false;
                }
                for (ImmersiveNetHandler.Connection c : this) {
                    if (other.contains(c)) continue;
                    return false;
                }
                return true;
            }
        };
        for (ImmersiveNetHandler.Connection c : conns) {
            IImmersiveConnectable end = ApiUtils.toIIC(c.end, this.field_145850_b, false);
            if (end == null) continue;
            c.getSubVertices(this.field_145850_b);
            ret.add(c);
        }
        return ret;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ImmersiveNetHandler.INSTANCE.addProxy(new IICProxy(this));
    }

    public void func_145829_t() {
        super.func_145829_t();
        ImmersiveNetHandler.INSTANCE.resetCachedIndirectConnections();
    }
}

