/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.cloth.BlockTypes_ClothDevice;
import blusunrize.immersiveengineering.common.blocks.cloth.ItemBlockClothDevice;
import blusunrize.immersiveengineering.common.blocks.cloth.TileEntityBalloon;
import blusunrize.immersiveengineering.common.blocks.cloth.TileEntityStripCurtain;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockClothDevice
extends BlockIETileProvider<BlockTypes_ClothDevice> {
    public BlockClothDevice() {
        super("clothDevice", Material.field_151580_n, PropertyEnum.func_177709_a((String)"type", BlockTypes_ClothDevice.class), ItemBlockClothDevice.class, new Object[]{IEProperties.FACING_ALL, IEProperties.BOOLEANS[0]});
        this.func_149711_c(0.8f);
        this.setHasColours();
        this.setMetaLightOpacity(1, 0);
        this.setMetaLightOpacity(2, 0);
        this.setMetaBlockLayer(1, BlockRenderLayer.SOLID, BlockRenderLayer.TRANSLUCENT);
        this.setNotNormalBlock(BlockTypes_ClothDevice.BALLOON.getMeta());
        this.setNotNormalBlock(BlockTypes_ClothDevice.STRIPCURTAIN.getMeta());
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(IBlockState state) {
        return 0xFFFFFF;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (ItemNBTHelper.hasKey(stack, "colour")) {
            String hexCol = Integer.toHexString(ItemNBTHelper.getInt(stack, "colour"));
            tooltip.add(I18n.func_74837_a((String)"desc.immersiveengineering.info.colour", (Object[])new Object[]{"<hexcol=" + hexCol + ":#" + hexCol + ">"}));
        }
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        if (meta == 2) {
            return "stripcurtain";
        }
        return null;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_180430_e(fallDistance, 0.0f);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        BlockStateContainer base = super.func_180661_e();
        IUnlistedProperty[] unlisted = base instanceof ExtendedBlockState ? ((ExtendedBlockState)base).getUnlistedProperties().toArray() : new IUnlistedProperty[]{};
        unlisted = Arrays.copyOf(unlisted, unlisted.length + 1);
        unlisted[unlisted.length - 1] = IEProperties.CONNECTIONS;
        return new ExtendedBlockState((Block)this, base.func_177623_d().toArray(new IProperty[0]), unlisted);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityImmersiveConnectable)) {
                return state;
            }
            state = ext.withProperty((IUnlistedProperty)IEProperties.CONNECTIONS, ((TileEntityImmersiveConnectable)te).genConnBlockstate());
        }
        return state;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (BlockTypes_ClothDevice.values()[meta]) {
            case CUSHION: {
                return null;
            }
            case BALLOON: {
                return new TileEntityBalloon();
            }
            case STRIPCURTAIN: {
                return new TileEntityStripCurtain();
            }
        }
        return null;
    }
}

