/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityStripCurtain
extends TileEntityIEBase
implements IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedDirectionalTile,
IEBlockInterfaces.IDualState,
IEBlockInterfaces.IColouredTile,
IEBlockInterfaces.ITileDrop {
    public EnumFacing facing = EnumFacing.NORTH;
    public boolean ceilingAttached = false;
    public int colour = 0xFFFFFF;
    AxisAlignedBB[] bounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 0.0625), new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 0.1875, 1.0), new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.8125, 0.46875, 1.0, 1.0, 0.53125), new AxisAlignedBB(0.46875, 0.8125, 0.0, 0.53125, 1.0, 1.0)};

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.ceilingAttached = nbt.func_74767_n("ceilingAttached");
        this.colour = nbt.func_74762_e("colour");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (this.facing != null) {
            nbt.func_74768_a("facing", this.facing.ordinal());
        }
        nbt.func_74757_a("ceilingAttached", this.ceilingAttached);
        nbt.func_74768_a("colour", this.colour);
    }

    @Override
    public float[] getBlockBounds() {
        AxisAlignedBB aabb = this.bounds[this.ceilingAttached ? (this.facing.func_176740_k() == EnumFacing.Axis.Z ? 4 : 5) : (this.facing.ordinal() - 2) % 4];
        return new float[]{(float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c, (float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        Object[] objectArray = new AxisAlignedBB[1];
        objectArray[0] = this.bounds[this.ceilingAttached ? (this.facing.func_176740_k() == EnumFacing.Axis.Z ? 4 : 5) : (this.facing.ordinal() - 2) % 4];
        return Lists.newArrayList((Object[])objectArray);
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public void onDirectionalPlacement(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        if (side == EnumFacing.DOWN) {
            this.ceilingAttached = true;
        }
    }

    @Override
    public boolean getIsSecondState() {
        return this.ceilingAttached;
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    @Override
    public int getRenderColour(int tintIndex) {
        if (tintIndex == 1) {
            return this.colour;
        }
        return 0xFFFFFF;
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        if (this.colour != 0xFFFFFF) {
            ItemNBTHelper.setInt(stack, "colour", this.colour);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "colour")) {
            this.colour = ItemNBTHelper.getInt(stack, "colour");
        }
    }
}

