/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.tool.AssemblerHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockAssembler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAssembler
extends TileEntityMultiblockMetal<TileEntityAssembler, IMultiblockRecipe>
implements IEBlockInterfaces.IGuiTile {
    public boolean[] computerOn = new boolean[3];
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000), new FluidTank(8000), new FluidTank(8000)};
    public ItemStack[] inventory = new ItemStack[21];
    public CrafterPatternInventory[] patterns = new CrafterPatternInventory[]{new CrafterPatternInventory(this), new CrafterPatternInventory(this), new CrafterPatternInventory(this)};
    IItemHandler insertionHandler = new IEInventoryHandler(18, (IIEInventory)this, 0, true, false);
    IItemHandler extractionHandler = new IEInventoryHandler(3, (IIEInventory)this, 18, false, true);

    public TileEntityAssembler() {
        super(MultiblockAssembler.instance, new int[]{3, 3, 3}, 32000, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank2"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 21);
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = nbt.func_150295_c("pattern" + iPattern, 10);
                this.patterns[iPattern] = new CrafterPatternInventory(this);
                this.patterns[iPattern].readFromNBT(patternList);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank2", (NBTBase)this.tanks[2].writeToNBT(new NBTTagCompound()));
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = new NBTTagList();
                this.patterns[iPattern].writeToNBT(patternList);
                nbt.func_74782_a("pattern" + iPattern, (NBTBase)patternList);
            }
        }
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        block4: {
            block3: {
                if (!message.func_74764_b("buttonID")) break block3;
                int id = message.func_74762_e("buttonID");
                if (id < 0 || id >= this.patterns.length) break block4;
                CrafterPatternInventory pattern = this.patterns[id];
                for (int i = 0; i < pattern.inv.length; ++i) {
                    pattern.inv[i] = null;
                }
                break block4;
            }
            if (message.func_74764_b("patternSync")) {
                int r = message.func_74762_e("recipe");
                NBTTagList list = message.func_150295_c("patternSync", 10);
                CrafterPatternInventory pattern = this.patterns[r];
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound itemTag = list.func_150305_b(i);
                    pattern.inv[itemTag.func_74762_e((String)"slot")] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
                }
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled() || this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 16L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0xF)) {
            return;
        }
        boolean update = false;
        ItemStack[][] outputBuffer = new ItemStack[this.patterns.length][0];
        for (int p = 0; p < this.patterns.length; ++p) {
            ItemStack[] remainingItems;
            CrafterPatternInventory pattern = this.patterns[p];
            if (this.controllingComputers != 0 && !this.computerOn[p]) {
                return;
            }
            if (pattern.inv[9] == null || !this.canOutput(pattern.inv[9], p)) continue;
            ItemStack output = pattern.inv[9].func_77946_l();
            ArrayList<ItemStack> queryList = new ArrayList<ItemStack>();
            ItemStack[][] itemStackArray = outputBuffer;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack[] itemStackArray2;
                for (ItemStack stack : itemStackArray2 = itemStackArray[i]) {
                    if (stack == null) continue;
                    queryList.add(stack.func_77946_l());
                }
            }
            for (ItemStack[] itemStackArray3 : this.inventory) {
                if (itemStackArray3 == null) continue;
                queryList.add(itemStackArray3.func_77946_l());
            }
            int consumed = Config.getInt("assembler_consumption");
            if (!this.hasIngredients(pattern, queryList) || this.energyStorage.extractEnergy(consumed, true) != consumed) continue;
            this.energyStorage.extractEnergy(consumed, false);
            ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
            outputList.add(output);
            AssemblerHandler.IRecipeAdapter adapter = AssemblerHandler.findAdapter(pattern.recipe);
            AssemblerHandler.RecipeQuery[] recipeQueryArray = adapter.getQueriedInputs(pattern.recipe, pattern.inv);
            ItemStack[] gridItems = new ItemStack[9];
            for (int i = 0; i < recipeQueryArray.length; ++i) {
                if (recipeQueryArray[i] == null) continue;
                AssemblerHandler.RecipeQuery recipeQuery = recipeQueryArray[i];
                Optional<ItemStack> taken = null;
                for (int j = 0; j < outputBuffer.length && (taken = this.consumeItem(recipeQuery.query, recipeQuery.querySize, outputBuffer[j], outputList)) == null; ++j) {
                }
                if (taken == null) {
                    taken = this.consumeItem(recipeQuery.query, recipeQuery.querySize, this.inventory, outputList);
                }
                if (taken == null) continue;
                gridItems[i] = (ItemStack)taken.orNull();
            }
            for (ItemStack rem : remainingItems = pattern.recipe.func_179532_b(Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, gridItems))) {
                if (rem == null) continue;
                outputList.add(rem);
            }
            outputBuffer[p] = outputList.toArray(new ItemStack[outputList.size()]);
            update = true;
        }
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.facing, 2));
        for (int buffer = 0; buffer < outputBuffer.length; ++buffer) {
            if (outputBuffer[buffer] == null || outputBuffer[buffer].length <= 0) continue;
            for (int iOutput = 0; iOutput < outputBuffer[buffer].length; ++iOutput) {
                ItemStack output = outputBuffer[buffer][iOutput];
                if (output == null || output.field_77994_a <= 0 || !this.isRecipeIngredient(output, buffer) && inventoryTile != null && ((output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.func_176734_d())) == null || output.field_77994_a <= 0)) continue;
                int free = -1;
                if (iOutput == 0) {
                    if (this.inventory[18 + buffer] == null && free < 0) {
                        free = 18 + buffer;
                    } else if (this.inventory[18 + buffer] != null && OreDictionary.itemMatches((ItemStack)output, (ItemStack)this.inventory[18 + buffer], (boolean)true) && this.inventory[18 + buffer].field_77994_a + output.field_77994_a <= this.inventory[18 + buffer].func_77976_d()) {
                        this.inventory[18 + buffer].field_77994_a += output.field_77994_a;
                        free = -1;
                        continue;
                    }
                } else {
                    for (int i = 0; i < this.inventory.length; ++i) {
                        if (this.inventory[i] == null && free < 0) {
                            free = i;
                            continue;
                        }
                        if (this.inventory[i] == null || !OreDictionary.itemMatches((ItemStack)output, (ItemStack)this.inventory[i], (boolean)true) || this.inventory[i].field_77994_a + output.field_77994_a > this.inventory[i].func_77976_d()) continue;
                        this.inventory[i].field_77994_a += output.field_77994_a;
                        free = -1;
                        break;
                    }
                }
                if (free < 0) continue;
                this.inventory[free] = output.func_77946_l();
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.isRecipeIngredient(this.inventory[18 + i], i) || inventoryTile == null) continue;
            this.inventory[18 + i] = Utils.insertStackIntoInventory(inventoryTile, this.inventory[18 + i], this.facing.func_176734_d());
        }
        if (update) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    public Optional<ItemStack> consumeItem(Object query, int querySize, ItemStack[] inventory, ArrayList<ItemStack> containerItems) {
        FluidStack fs;
        Object object = query instanceof FluidStack ? (FluidStack)query : (fs = query instanceof IngredientStack && ((IngredientStack)query).fluid != null ? ((IngredientStack)query).fluid : null);
        if (fs != null) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                tank.drain(fs.amount, true);
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
                return Optional.absent();
            }
        }
        Optional ret = null;
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !Utils.stackMatchesObject(inventory[i], query, true)) continue;
            int taken = Math.min(querySize, inventory[i].field_77994_a);
            boolean doTake = true;
            if (doTake) {
                ret = Optional.of((Object)inventory[i].func_77979_a(taken));
                if (inventory[i].field_77994_a <= 0) {
                    inventory[i] = null;
                }
            }
            if ((querySize -= taken) <= 0) break;
        }
        if (query == null || querySize <= 0) {
            return ret;
        }
        return null;
    }

    public boolean hasIngredients(CrafterPatternInventory pattern, ArrayList<ItemStack> queryList) {
        AssemblerHandler.RecipeQuery[] queries;
        boolean match = true;
        AssemblerHandler.IRecipeAdapter adapter = AssemblerHandler.findAdapter(pattern.recipe);
        for (AssemblerHandler.RecipeQuery recipeQuery : queries = adapter.getQueriedInputs(pattern.recipe, pattern.inv)) {
            FluidStack fs;
            if (recipeQuery == null || recipeQuery.query == null) continue;
            Object object = recipeQuery.query instanceof FluidStack ? (FluidStack)recipeQuery.query : (fs = recipeQuery.query instanceof IngredientStack && ((IngredientStack)recipeQuery.query).fluid != null ? ((IngredientStack)recipeQuery.query).fluid : null);
            if (fs != null) {
                boolean hasFluid = false;
                for (FluidTank tank : this.tanks) {
                    if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                    hasFluid = true;
                    break;
                }
                if (hasFluid) continue;
            }
            int querySize = recipeQuery.querySize;
            Iterator<ItemStack> it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (next == null || !Utils.stackMatchesObject(next, recipeQuery.query, true)) continue;
                int taken = Math.min(querySize, next.field_77994_a);
                next.field_77994_a -= taken;
                if (next.field_77994_a <= 0) {
                    it.remove();
                }
                if ((querySize -= taken) > 0) continue;
                break;
            }
            if (querySize <= 0) continue;
            match = false;
            break;
        }
        return match;
    }

    public boolean canOutput(ItemStack output, int iPattern) {
        if (this.inventory[18 + iPattern] == null) {
            return true;
        }
        return OreDictionary.itemMatches((ItemStack)output, (ItemStack)this.inventory[18 + iPattern], (boolean)true) && ItemStack.func_77970_a((ItemStack)output, (ItemStack)this.inventory[18 + iPattern]) && this.inventory[18 + iPattern].field_77994_a + output.field_77994_a <= this.inventory[18 + iPattern].func_77976_d();
    }

    public boolean isRecipeIngredient(ItemStack stack, int slot) {
        if (stack == null) {
            return false;
        }
        if (slot - 1 < this.patterns.length) {
            for (int p = slot; p < this.patterns.length; ++p) {
                CrafterPatternInventory pattern = this.patterns[p];
                for (int i = 0; i < 9; ++i) {
                    if (pattern.inv[i] == null || !OreDictionary.itemMatches((ItemStack)pattern.inv[i], (ItemStack)stack, (boolean)false)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c < 9 || this.field_174879_c == 10 || this.field_174879_c == 13 || this.field_174879_c == 16 || this.field_174879_c == 22) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.SOUTH || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.NORTH) {
            zMin = 0.25f;
        } else if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.NORTH || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.SOUTH) {
            zMax = 0.75f;
        } else if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.EAST || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.WEST) {
            xMin = 0.25f;
        } else if (this.field_174879_c % 9 < 3 && this.facing == EnumFacing.WEST || this.field_174879_c % 9 >= 6 && this.facing == EnumFacing.EAST) {
            xMax = 0.75f;
        }
        if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.EAST || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.WEST) {
            zMin = 0.1875f;
        } else if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.WEST || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.EAST) {
            zMax = 0.8125f;
        } else if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.NORTH || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.SOUTH) {
            xMin = 0.1875f;
        } else if (this.field_174879_c % 3 == 0 && this.facing == EnumFacing.SOUTH || this.field_174879_c % 3 == 2 && this.facing == EnumFacing.NORTH) {
            xMax = 0.8125f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{22};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{3, 5};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.func_174877_v().func_177967_a(this.facing, -1);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory(inventoryTile, output, this.facing.func_176734_d());
        }
        if (output != null) {
            Utils.dropStackAtPos(this.field_145850_b, pos, output, this.facing);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public FluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((this.field_174879_c == 10 || this.field_174879_c == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.field_174879_c == 10 && facing == this.facing.func_176734_d() || this.field_174879_c == 16 && facing == this.facing;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((this.field_174879_c == 10 || this.field_174879_c == 16) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityAssembler master = (TileEntityAssembler)this.master();
            if (master == null) {
                return null;
            }
            if (this.field_174879_c == 10 && facing == this.facing.func_176734_d()) {
                return (T)master.insertionHandler;
            }
            if (this.field_174879_c == 16 && facing == this.facing) {
                return (T)master.extractionHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 4;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    protected FluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityAssembler master = (TileEntityAssembler)this.master();
        if (master != null && this.field_174879_c == 1 && (side == null || side == this.facing.func_176734_d())) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return true;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return true;
    }

    public static class CrafterPatternInventory
    implements IInventory {
        public ItemStack[] inv = new ItemStack[10];
        public IRecipe recipe;
        final TileEntityAssembler tile;

        public CrafterPatternInventory(TileEntityAssembler tile) {
            this.tile = tile;
        }

        public int func_70302_i_() {
            return 10;
        }

        public ItemStack func_70301_a(int slot) {
            return this.inv[slot];
        }

        public ItemStack func_70298_a(int slot, int amount) {
            ItemStack stack = this.func_70301_a(slot);
            if (slot < 9 && stack != null) {
                if (stack.field_77994_a <= amount) {
                    this.func_70299_a(slot, null);
                } else {
                    stack = stack.func_77979_a(amount);
                    if (stack.field_77994_a == 0) {
                        this.func_70299_a(slot, null);
                    }
                }
            }
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null) {
                this.func_70299_a(slot, null);
            }
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            if (slot < 9) {
                this.inv[slot] = stack;
                if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                    stack.field_77994_a = this.func_70297_j_();
                }
            }
            this.recalculateOutput();
        }

        public void func_174888_l() {
            for (int i = 0; i < this.inv.length; ++i) {
                this.inv[i] = null;
            }
        }

        public void recalculateOutput() {
            InventoryCrafting invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, this.inv);
            this.recipe = Utils.findRecipe(invC, this.tile.func_145831_w());
            this.inv[9] = this.recipe != null ? this.recipe.func_77572_b(invC) : null;
        }

        public ArrayList<ItemStack> getTotalPossibleOutputs() {
            ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
            outputList.add(this.inv[9].func_77946_l());
            for (int i = 0; i < 9; ++i) {
                FluidStack fs = FluidUtil.getFluidContained((ItemStack)this.inv[i]);
                if (fs == null) continue;
                boolean hasFluid = false;
                for (FluidTank tank : this.tile.tanks) {
                    if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                    hasFluid = true;
                    break;
                }
                if (!hasFluid) continue;
            }
            InventoryCrafting invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, this.inv);
            for (ItemStack ss : this.recipe.func_179532_b(invC)) {
                if (ss == null) continue;
                outputList.add(ss);
            }
            return outputList;
        }

        public String func_70005_c_() {
            return "IECrafterPattern";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.inv.length; ++i) {
                if (this.inv[i] == null) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", (byte)i);
                this.inv[i].func_77955_b(itemTag);
                list.func_74742_a((NBTBase)itemTag);
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound itemTag = list.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            }
            this.recalculateOutput();
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentString(this.func_70005_c_());
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }
    }
}

