/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityBreakerSwitch
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IPlayerInteraction {
    public int sideAttached = 0;
    public EnumFacing facing = EnumFacing.NORTH;
    public int wires = 0;
    public boolean active = false;
    public boolean inverted = false;

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    protected boolean canTakeMV() {
        return true;
    }

    @Override
    protected boolean canTakeHV() {
        return false;
    }

    @Override
    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return this.active;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (cableType != null && !cableType.isEnergyWire()) {
            return false;
        }
        if (cableType == WireType.STEEL && !this.canTakeHV()) {
            return false;
        }
        if (this.wires >= 2) {
            return false;
        }
        return this.limitType == null || cableType == this.limitType;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        if (this.limitType == null) {
            this.limitType = cableType;
        }
        ++this.wires;
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return this.limitType;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        this.wires = type == null ? 0 : --this.wires;
        if (this.wires <= 0) {
            this.limitType = null;
        }
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74768_a("sideAttached", this.sideAttached);
        nbt.func_74768_a("wires", this.wires);
        nbt.func_74757_a("active", this.active);
        nbt.func_74757_a("inverted", this.inverted);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.sideAttached = nbt.func_74762_e("sideAttached");
        this.wires = nbt.func_74762_e("wires");
        this.active = nbt.func_74767_n("active");
        this.inverted = nbt.func_74767_n("inverted");
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        return new Vec3d(0.5, 0.5, 0.5);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        int zDif;
        int xDif;
        BlockPos here = this.func_174877_v();
        if (this.facing.func_176740_k() == EnumFacing.Axis.Y) {
            int xDif2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)here) && con.end != null ? con.end.func_177958_n() - here.func_177958_n() : (con.end.equals((Object)here) && con.start != null ? con.start.func_177958_n() - here.func_177958_n() : 0));
            return new Vec3d(xDif2 < 0 ? 0.25 : 0.75, this.facing == EnumFacing.UP ? 0.875 : 0.125, 0.5);
        }
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)here) && con.end != null ? con.end.func_177958_n() - here.func_177958_n() : (xDif = con.end.equals((Object)here) && con.start != null ? con.start.func_177958_n() - here.func_177958_n() : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)here) && con.end != null ? con.end.func_177952_p() - here.func_177952_p() : (zDif = con.end.equals((Object)here) && con.start != null ? con.start.func_177952_p() - here.func_177952_p() : 0));
        return new Vec3d(this.facing == EnumFacing.WEST ? 0.125 : (this.facing == EnumFacing.EAST ? 0.875 : (xDif < 0 ? 0.25 : 0.75)), 0.5, this.facing == EnumFacing.NORTH ? 0.125 : (this.facing == EnumFacing.SOUTH ? 0.875 : (zDif < 0 ? 0.25 : 0.75)));
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        this.inverted = !this.inverted;
        ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsSignal." + (this.inverted ? "invertedOn" : "invertedOff"), new Object[0])});
        this.notifyNeighbours();
        return true;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        this.active = !this.active;
        ImmersiveNetHandler.INSTANCE.resetCachedIndirectConnections();
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), this.active ? 1 : 0, 0);
        this.notifyNeighbours();
        return true;
    }

    public void notifyNeighbours() {
        this.func_70296_d();
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
        for (EnumFacing f : EnumFacing.field_82609_l) {
            this.field_145850_b.func_175685_c(this.func_174877_v().func_177972_a(f), this.func_145838_q());
        }
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (super.func_145842_c(id, arg)) {
            return true;
        }
        this.active = id == 1;
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    @Override
    public boolean getIsActive() {
        return this.inverted != this.active;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 0;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.facing == EnumFacing.DOWN) {
            return new float[]{0.25f, 0.0f, 0.1875f, 0.75f, 0.5f, 0.8125f};
        }
        if (this.facing == EnumFacing.UP) {
            return new float[]{0.25f, 0.5f, 0.1875f, 0.75f, 1.0f, 0.8125f};
        }
        float[] fArray = new float[6];
        fArray[0] = this.facing == EnumFacing.WEST ? 0.0f : (this.facing == EnumFacing.EAST ? 0.5f : 0.25f);
        fArray[1] = 0.1875f;
        float f = this.facing == EnumFacing.NORTH ? 0.0f : (fArray[2] = this.facing == EnumFacing.SOUTH ? 0.5f : 0.25f);
        fArray[3] = this.facing == EnumFacing.WEST ? 0.5f : (this.facing == EnumFacing.EAST ? 1.0f : 0.75f);
        fArray[4] = 0.8125f;
        fArray[5] = this.facing == EnumFacing.NORTH ? 0.5f : (this.facing == EnumFacing.SOUTH ? 1.0f : 0.75f);
        return fArray;
    }
}

