/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTransformerHV;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTransformer
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IMirrorAble,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IDualState {
    WireType secondCable;
    public EnumFacing facing = EnumFacing.NORTH;
    public int dummy = 0;
    public boolean onPost = false;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public static boolean _Immovable() {
        return true;
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    protected boolean canTakeMV() {
        return true;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return false;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing.ordinal());
        if (this.secondCable != null) {
            nbt.func_74778_a("secondCable", this.secondCable.getUniqueName());
        }
        nbt.func_74768_a("dummy", this.dummy);
        nbt.func_74757_a("postAttached", this.onPost);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.secondCable = nbt.func_74764_b("secondCable") ? ApiUtils.getWireTypeFromNBT(nbt, "secondCable") : null;
        this.dummy = nbt.func_74762_e("dummy");
        this.onPost = nbt.func_74767_n("postAttached");
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.func_174877_v().func_177982_a(0, -this.dummy, 0);
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (cableType == WireType.STEEL && !this.canTakeHV()) {
            return false;
        }
        if (this.dummy != 0) {
            TileEntity master = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0));
            if (master instanceof TileEntityTransformer) {
                return ((TileEntityTransformer)master).canConnectCable(cableType, target);
            }
            return false;
        }
        int tc = this.getTargetedConnector(target);
        switch (tc) {
            case 0: {
                return this.limitType == null && this.secondCable != cableType;
            }
            case 1: {
                return this.secondCable == null && this.limitType != cableType;
            }
        }
        return false;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        if (this.dummy != 0) {
            TileEntity master = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0));
            if (master instanceof TileEntityTransformer) {
                ((TileEntityTransformer)master).connectCable(cableType, target, other);
            }
            return;
        }
        switch (this.getTargetedConnector(target)) {
            case 0: {
                if (this.limitType != null) break;
                this.limitType = cableType;
                break;
            }
            case 1: {
                if (this.secondCable != null) break;
                this.secondCable = cableType;
            }
        }
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        switch (this.getTargetedConnector(target)) {
            case 0: {
                return this.limitType;
            }
            case 1: {
                return this.secondCable;
            }
        }
        return null;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        if (type == null) {
            this.limitType = null;
            this.secondCable = null;
        }
        if (type == this.limitType) {
            this.limitType = null;
        }
        if (type == this.secondCable) {
            this.secondCable = null;
        }
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        if (this.onPost) {
            return new Vec3d(0.5, 1.5, 0.5);
        }
        return new Vec3d(0.5, 2.75, 0.5);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        double offset;
        boolean b;
        boolean bl = b = con.cableType == this.limitType;
        if (this.onPost) {
            if (b) {
                return new Vec3d(0.5 + (this.facing == EnumFacing.EAST ? 0.4375 : (this.facing == EnumFacing.WEST ? -0.4375 : 0.0)), 1.4375, 0.5 + (this.facing == EnumFacing.SOUTH ? 0.4375 : (this.facing == EnumFacing.NORTH ? -0.4375 : 0.0)));
            }
            return new Vec3d(0.5 + (this.facing == EnumFacing.EAST ? -0.0625 : (this.facing == EnumFacing.WEST ? 0.0625 : 0.0)), 0.25, 0.5 + (this.facing == EnumFacing.SOUTH ? -0.0625 : (this.facing == EnumFacing.NORTH ? 0.0625 : 0.0)));
        }
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        double d = con.cableType == WireType.COPPER ? -0.0625 : (offset = con.cableType == WireType.ELECTRUM ? 0.0625 : 0.25);
        if (this.facing == EnumFacing.NORTH) {
            return new Vec3d(b ? 0.8125 : 0.1875, 2.5 + offset - conRadius, 0.5);
        }
        if (this.facing == EnumFacing.SOUTH) {
            return new Vec3d(b ? 0.1875 : 0.8125, 2.5 + offset - conRadius, 0.5);
        }
        if (this.facing == EnumFacing.WEST) {
            return new Vec3d(0.5, 2.5 + offset - conRadius, b ? 0.1875 : 0.8125);
        }
        if (this.facing == EnumFacing.EAST) {
            return new Vec3d(0.5, 2.5 + offset - conRadius, b ? 0.8125 : 0.1875);
        }
        return new Vec3d(0.5, 0.5, 0.5);
    }

    public int getTargetedConnector(TargetingInfo target) {
        if (this.onPost) {
            if ((double)target.hitY >= 0.5) {
                return 0;
            }
            return 1;
        }
        if (this.facing == EnumFacing.NORTH) {
            if ((double)target.hitX < 0.5) {
                return 1;
            }
            return 0;
        }
        if (this.facing == EnumFacing.SOUTH) {
            if ((double)target.hitX < 0.5) {
                return 0;
            }
            return 1;
        }
        if (this.facing == EnumFacing.WEST) {
            if ((double)target.hitZ < 0.5) {
                return 0;
            }
            return 1;
        }
        if (this.facing == EnumFacing.EAST) {
            if ((double)target.hitZ < 0.5) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public WireType getLimiter(int side) {
        if (side == 0) {
            return this.limitType;
        }
        return this.secondCable;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 16), (double)(this.func_174877_v().func_177956_o() - 16), (double)(this.func_174877_v().func_177952_p() - 16), (double)(this.func_174877_v().func_177958_n() + 16), (double)(this.func_174877_v().func_177956_o() + 16), (double)(this.func_174877_v().func_177952_p() + 16));
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return inf == IEBlockInterfaces.IMirrorAble.class ? IEProperties.BOOLEANS[0] : (inf == IEBlockInterfaces.IDualState.class ? IEProperties.BOOLEANS[1] : null);
    }

    @Override
    public boolean getIsMirrored() {
        if (this.onPost) {
            return false;
        }
        WireType lower = this instanceof TileEntityTransformerHV ? WireType.ELECTRUM : WireType.COPPER;
        boolean b = this.limitType != null && lower.equals(this.limitType) || this.secondCable != null && !lower.equals(this.secondCable);
        return !b;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    public boolean isOnPost() {
        return this.onPost;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)IEProperties.BOOLEANS[1])).booleanValue()) {
            this.onPost = true;
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        } else {
            for (int i = 1; i <= 2; ++i) {
                this.field_145850_b.func_175656_a(pos.func_177982_a(0, i, 0), state);
                ((TileEntityTransformer)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)i, (int)0))).dummy = i;
                ((TileEntityTransformer)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)i, (int)0))).facing = this.facing;
            }
        }
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        if (this.onPost) {
            return;
        }
        for (int i = 0; i <= 2; ++i) {
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0));
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.dummy == 2) {
            return new float[]{this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0.0f : 0.3125f, 0.0f, this.facing.func_176740_k() == EnumFacing.Axis.X ? 0.0f : 0.3125f, this.facing.func_176740_k() == EnumFacing.Axis.Z ? 1.0f : 0.6875f, this instanceof TileEntityTransformerHV ? 0.75f : 0.5625f, this.facing.func_176740_k() == EnumFacing.Axis.X ? 1.0f : 0.6875f};
        }
        if (this.onPost) {
            float[] fArray = new float[6];
            fArray[0] = this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0.25f : (this.facing == EnumFacing.WEST ? -0.375f : 0.6875f);
            fArray[1] = 0.0f;
            float f = this.facing.func_176740_k() == EnumFacing.Axis.X ? 0.25f : (fArray[2] = this.facing == EnumFacing.NORTH ? -0.375f : 0.6875f);
            fArray[3] = this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0.75f : (this.facing == EnumFacing.EAST ? 1.375f : 0.3125f);
            fArray[4] = 1.0f;
            fArray[5] = this.facing.func_176740_k() == EnumFacing.Axis.X ? 0.75f : (this.facing == EnumFacing.SOUTH ? 1.375f : 0.3125f);
            return fArray;
        }
        return null;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        if (this.dummy == 2) {
            double offsetH;
            double offsetL;
            boolean b;
            WireType lower = this instanceof TileEntityTransformerHV ? WireType.ELECTRUM : WireType.COPPER;
            WireType higher = this instanceof TileEntityTransformerHV ? WireType.STEEL : WireType.ELECTRUM;
            boolean bl = b = this.limitType != null && lower.equals(this.limitType) || this.secondCable != null && !lower.equals(this.secondCable);
            double d = lower == WireType.COPPER ? 0.0 : (offsetL = lower == WireType.ELECTRUM ? 0.0625 : 0.25);
            double d2 = higher == WireType.COPPER ? 0.0 : (offsetH = higher == WireType.ELECTRUM ? 0.0625 : 0.25);
            if (this.facing == EnumFacing.NORTH) {
                return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.3125, 0.375, 0.5 + (b ? offsetH : offsetL), 0.6875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()), new AxisAlignedBB(0.625, 0.0, 0.3125, 1.0, 0.5 + (b ? offsetL : offsetH), 0.6875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            }
            if (this.facing == EnumFacing.SOUTH) {
                return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.3125, 0.375, 0.5 + (b ? offsetL : offsetH), 0.6875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()), new AxisAlignedBB(0.625, 0.0, 0.3125, 1.0, 0.5 + (b ? offsetH : offsetL), 0.6875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            }
            if (this.facing == EnumFacing.WEST) {
                return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.5 + (b ? offsetL : offsetH), 0.375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()), new AxisAlignedBB(0.3125, 0.0, 0.625, 0.6875, 0.5 + (b ? offsetH : offsetL), 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            }
            if (this.facing == EnumFacing.EAST) {
                return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.5 + (b ? offsetH : offsetL), 0.375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()), new AxisAlignedBB(0.3125, 0.0, 0.625, 0.6875, 0.5 + (b ? offsetL : offsetH), 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            }
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return box.func_72314_b(0.002, 0.002, 0.002).func_72318_a(mop.field_72307_f);
    }

    @Override
    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        if (this.onPost) {
            return super.getIgnored(other);
        }
        return ImmutableSet.of((Object)this.field_174879_c.func_177984_a(), (Object)this.field_174879_c.func_177981_b(2));
    }

    @Override
    public boolean getIsSecondState() {
        return this.onPost;
    }
}

