/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityDynamo;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWatermill
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IHasObjProperty {
    public EnumFacing facing = EnumFacing.NORTH;
    public int[] offset = new int[]{0, 0};
    public float rotation = 0.0f;
    private Vec3d rotationVec = null;
    public boolean canTurn = false;
    public boolean multiblock = false;
    public float prevRotation = 0.0f;
    private boolean formed = true;
    public double perTick;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    static ArrayList<String> emptyDisplayList = new ArrayList();

    public void func_73660_a() {
        if (this.offset[0] != 0 || this.offset[1] != 0 || this.field_145850_b == null) {
            return;
        }
        if (this.isBlocked()) {
            this.canTurn = false;
            return;
        }
        boolean bl = this.canTurn = this.getRotationVec().func_72433_c() != 0.0;
        if (this.field_145850_b.func_82737_E() % 256L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0xFF)) {
            this.rotationVec = null;
        }
        this.prevRotation = this.rotation;
        if (!this.multiblock && this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facing.func_176734_d())) instanceof TileEntityDynamo) {
            double power = this.getPower();
            int l = 1;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.facing, l));
            while (l < 3 && this.canUse(tileEntity)) {
                power += ((TileEntityWatermill)tileEntity).getPower();
                tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.facing, ++l));
            }
            double perTick = 6.944444612599909E-4 * power / (double)l;
            this.canTurn = perTick != 0.0;
            this.rotation = (float)((double)this.rotation + perTick);
            this.rotation %= 1.0f;
            for (int l2 = 1; l2 < l; ++l2) {
                tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.facing, l2));
                if (!(tileEntity instanceof TileEntityWatermill)) continue;
                ((TileEntityWatermill)tileEntity).rotation = this.rotation;
                ((TileEntityWatermill)tileEntity).canTurn = this.canTurn;
                ((TileEntityWatermill)tileEntity).multiblock = true;
            }
            if (!this.field_145850_b.field_72995_K) {
                TileEntityDynamo dynamo = (TileEntityDynamo)this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facing.func_176734_d()));
                dynamo.inputRotation(Math.abs(power * 0.75), this.facing.func_176734_d());
            }
        } else if (!this.multiblock) {
            this.perTick = 6.944444612599909E-4 * this.getPower();
            this.canTurn = this.perTick != 0.0;
            this.rotation = (float)((double)this.rotation + this.perTick);
            this.rotation %= 1.0f;
        }
        if (this.multiblock) {
            this.multiblock = false;
        }
    }

    private boolean canUse(TileEntity tileEntity) {
        return tileEntity instanceof TileEntityWatermill && ((TileEntityWatermill)tileEntity).offset[0] == 0 && ((TileEntityWatermill)tileEntity).offset[1] == 0 && (((TileEntityWatermill)tileEntity).facing == this.facing || ((TileEntityWatermill)tileEntity).facing == this.facing.func_176734_d()) && !((TileEntityWatermill)tileEntity).isBlocked() && !((TileEntityWatermill)tileEntity).multiblock;
    }

    public boolean isBlocked() {
        if (this.field_145850_b == null) {
            return true;
        }
        for (EnumFacing fdY : new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN}) {
            EnumFacing[] enumFacingArray;
            if (this.facing.func_176740_k() == EnumFacing.Axis.Z) {
                EnumFacing[] enumFacingArray2 = new EnumFacing[2];
                enumFacingArray2[0] = EnumFacing.EAST;
                enumFacingArray = enumFacingArray2;
                enumFacingArray2[1] = EnumFacing.WEST;
            } else {
                EnumFacing[] enumFacingArray3 = new EnumFacing[2];
                enumFacingArray3[0] = EnumFacing.SOUTH;
                enumFacingArray = enumFacingArray3;
                enumFacingArray3[1] = EnumFacing.NORTH;
            }
            for (EnumFacing fdW : enumFacingArray) {
                BlockPos pos = this.func_174877_v().func_177967_a(fdW, 2).func_177967_a(fdY, 2);
                IBlockState state = this.field_145850_b.func_180495_p(pos);
                if (state == null) {
                    return false;
                }
                if (state.isSideSolid((IBlockAccess)this.field_145850_b, pos, fdW.func_176734_d())) {
                    return true;
                }
                if (!state.isSideSolid((IBlockAccess)this.field_145850_b, pos, fdY.func_176734_d())) continue;
                return true;
            }
        }
        return false;
    }

    public double getPower() {
        return this.facing.func_176740_k() == EnumFacing.Axis.Z ? -this.getRotationVec().field_72450_a : this.getRotationVec().field_72449_c;
    }

    public void resetRotationVec() {
        this.rotationVec = null;
    }

    public Vec3d getRotationVec() {
        if (this.rotationVec == null) {
            this.rotationVec = new Vec3d(0.0, 0.0, 0.0);
            Vec3d dirHoz = this.getHorizontalVec();
            Vec3d dirVer = this.getVerticalVec();
            this.rotationVec = Utils.addVectors(this.rotationVec, dirHoz);
            this.rotationVec = Utils.addVectors(this.rotationVec, dirVer);
        }
        return this.rotationVec;
    }

    Vec3d getHorizontalVec() {
        Vec3d dir = new Vec3d(0.0, 0.0, 0.0);
        boolean faceZ = this.facing.ordinal() <= 3;
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(faceZ ? 1 : 0), 3, -(faceZ ? 0 : 1))));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(0, 3, 0)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(faceZ ? 1 : 0, 3, faceZ ? 0 : 1)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(faceZ ? 2 : 0), 2, -(faceZ ? 0 : 2))));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(faceZ ? 2 : 0, 2, faceZ ? 0 : 2)));
        dir = dir.func_178788_d(Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(faceZ ? 2 : 0), -2, -(faceZ ? 0 : 2))));
        dir = dir.func_178788_d(Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(faceZ ? 2 : 0, -2, faceZ ? 0 : 2)));
        dir = dir.func_178788_d(Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(faceZ ? 1 : 0), -3, -(faceZ ? 0 : 1))));
        dir = dir.func_178788_d(Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(0, -3, 0)));
        dir = dir.func_178788_d(Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(faceZ ? 1 : 0, -3, faceZ ? 0 : 1)));
        return dir;
    }

    Vec3d getVerticalVec() {
        Vec3d dir = new Vec3d(0.0, 0.0, 0.0);
        Vec3d dirNeg = new Vec3d(0.0, 0.0, 0.0);
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 2 : 0), 2, -(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 2))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 3 : 0), 1, -(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 3))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 3 : 0), 0, -(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 3))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 3 : 0), -1, -(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 3))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(-(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 2 : 0), -2, -(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 2))));
        Vec3d dirPos = new Vec3d(0.0, 0.0, 0.0);
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 2 : 0, 2, this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 2)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 3 : 0, 1, this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 3 : 0, 0, this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 3 : 0, -1, this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.func_174877_v().func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 2 : 0, -2, this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 2)));
        dir = this.facing.func_176740_k() == EnumFacing.Axis.Z ? dir.func_72441_c(dirNeg.field_72448_b - dirPos.field_72448_b, 0.0, 0.0) : dir.func_72441_c(0.0, 0.0, dirNeg.field_72448_b - dirPos.field_72448_b);
        return dir;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        this.rotationVec = new Vec3d((double)((float)id / 10000.0f), 0.0, (double)((float)arg / 10000.0f));
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.prevRotation = nbt.func_74760_g("prevRotation");
        this.offset = nbt.func_74759_k("offset");
        this.rotation = nbt.func_74760_g("rotation");
        if (this.offset == null || this.offset.length < 2) {
            this.offset = new int[]{0, 0};
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74776_a("prevRotation", this.prevRotation);
        nbt.func_74783_a("offset", this.offset);
        nbt.func_74776_a("rotation", this.rotation);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offset[0] == 0 && this.offset[1] == 0 ? new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - (this.facing.func_176740_k() == EnumFacing.Axis.Z ? 2 : 0)), (double)(this.func_174877_v().func_177956_o() - 2), (double)(this.func_174877_v().func_177952_p() - (this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 2)), (double)(this.func_174877_v().func_177958_n() + (this.facing.func_176740_k() == EnumFacing.Axis.Z ? 3 : 0)), (double)(this.func_174877_v().func_177956_o() + 3), (double)(this.func_174877_v().func_177952_p() + (this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 3))) : new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
        }
        return this.renderAABB;
    }

    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2)) continue;
                BlockPos pos2 = pos.func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? ww : 0, hh, this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : ww);
                this.field_145850_b.func_175656_a(pos2, state);
                TileEntityWatermill dummy = (TileEntityWatermill)this.field_145850_b.func_175625_s(pos2);
                dummy.facing = this.facing;
                dummy.offset = new int[]{ww, hh};
            }
        }
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        if (!this.formed) {
            return;
        }
        BlockPos initPos = pos.func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? -this.offset[0] : 0, -this.offset[1], this.facing.func_176740_k() == EnumFacing.Axis.X ? -this.offset[0] : 0);
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                BlockPos pos2;
                TileEntity te;
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2) || !((te = this.field_145850_b.func_175625_s(pos2 = initPos.func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? ww : 0, hh, this.facing.func_176740_k() == EnumFacing.Axis.X ? ww : 0))) instanceof TileEntityWatermill)) continue;
                ((TileEntityWatermill)te).formed = false;
                this.field_145850_b.func_175698_g(pos2);
            }
        }
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        return emptyDisplayList;
    }
}

