/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityDynamo;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWindmill
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHasObjProperty {
    public EnumFacing facing = EnumFacing.NORTH;
    public float prevRotation = 0.0f;
    public float rotation = 0.0f;
    public float turnSpeed = 0.0f;
    public float perTick = 0.0f;
    public boolean canTurn = false;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    static ArrayList<String> emptyDisplayList = new ArrayList();

    public void func_73660_a() {
        TileEntity tileEntity;
        if (this.field_145850_b.func_82737_E() % 128L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x7F)) {
            this.canTurn = this.checkArea();
        }
        if (!this.canTurn) {
            return;
        }
        double mod = 5.0E-5;
        if (!this.field_145850_b.func_72896_J()) {
            mod *= 0.75;
        }
        if (!this.field_145850_b.func_72911_I()) {
            mod *= 0.66;
        }
        if (this.func_174877_v().func_177956_o() > 200) {
            mod *= 2.0;
        } else if (this.func_174877_v().func_177956_o() > 150) {
            mod *= 1.5;
        } else if (this.func_174877_v().func_177956_o() > 100) {
            mod *= 1.25;
        } else if (this.func_174877_v().func_177956_o() < 70) {
            mod *= 0.33;
        }
        this.prevRotation = (float)((double)this.turnSpeed * (mod *= (double)this.getSpeedModifier()));
        this.rotation = (float)((double)this.rotation + (double)this.turnSpeed * mod);
        this.rotation %= 1.0f;
        this.perTick = (float)((double)this.turnSpeed * mod);
        if (!this.field_145850_b.field_72995_K && (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing))) instanceof TileEntityDynamo) {
            TileEntityDynamo dynamo = (TileEntityDynamo)tileEntity;
            double power = (double)this.turnSpeed * mod * 400.0;
            dynamo.inputRotation(Math.abs(power), this.facing);
        }
    }

    protected float getSpeedModifier() {
        return 0.5f;
    }

    public boolean checkArea() {
        this.turnSpeed = 0.0f;
        for (int hh = -6; hh <= 6; ++hh) {
            int r = Math.abs(hh) == 6 ? 1 : (Math.abs(hh) == 5 ? 3 : (Math.abs(hh) == 4 ? 4 : (Math.abs(hh) > 1 ? 5 : 6)));
            for (int ww = -r; ww <= r; ++ww) {
                if (hh == 0 && ww == 0 || this.field_145850_b.func_175623_d(this.func_174877_v().func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? ww : 0, hh, this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : ww))) continue;
                return false;
            }
        }
        int blocked = 0;
        for (int hh = -6; hh <= 6; ++hh) {
            int r = Math.abs(hh) == 6 ? 1 : (Math.abs(hh) == 5 ? 3 : (Math.abs(hh) == 4 ? 4 : (Math.abs(hh) > 1 ? 5 : 6)));
            for (int ww = -r; ww <= r; ++ww) {
                for (int dd = 1; dd < 8; ++dd) {
                    BlockPos pos = this.func_174877_v().func_177982_a(0, hh, 0).func_177967_a(this.facing.func_176734_d(), dd).func_177967_a(this.facing.func_176746_e(), ww);
                    if (this.field_145850_b.func_175623_d(pos)) {
                        this.turnSpeed += 1.0f;
                        continue;
                    }
                    if (this.field_145850_b.func_175625_s(pos) instanceof TileEntityWindmill) {
                        blocked += 20;
                        this.turnSpeed -= 179.0f;
                        continue;
                    }
                    ++blocked;
                }
            }
            if (blocked <= 100) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.rotation = nbt.func_74760_g("rotation");
        this.turnSpeed = nbt.func_74760_g("turnSpeed");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74776_a("rotation", this.rotation);
        nbt.func_74776_a("turnSpeed", this.turnSpeed);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - (this.facing.func_176740_k() == EnumFacing.Axis.Z ? 6 : 0)), (double)(this.func_174877_v().func_177956_o() - 6), (double)(this.func_174877_v().func_177952_p() - (this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 6)), (double)(this.func_174877_v().func_177958_n() + (this.facing.func_176740_k() == EnumFacing.Axis.Z ? 7 : 0)), (double)(this.func_174877_v().func_177956_o() + 7), (double)(this.func_174877_v().func_177952_p() + (this.facing.func_176740_k() == EnumFacing.Axis.Z ? 0 : 7)));
        }
        return this.renderAABB;
    }

    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        return emptyDisplayList;
    }
}

