/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipesBanners;
import net.minecraft.tileentity.TileEntityBanner;

public class RecipeBannerAdvanced
extends RecipesBanners.RecipeAddPattern {
    public static LinkedHashMap<TileEntityBanner.EnumBannerPattern, RecipeReference> advancedPatterns = new LinkedHashMap();

    public static void addAdvancedPatternRecipe(TileEntityBanner.EnumBannerPattern pattern, IngredientStack stack, int ... offset) {
        if (offset != null && offset.length > 0) {
            int[] slotOffset = new int[2];
            slotOffset[0] = offset[0];
            if (offset.length > 1) {
                slotOffset[1] = offset[1];
            }
            advancedPatterns.put(pattern, new RecipeReference(stack, slotOffset));
        } else {
            advancedPatterns.put(pattern, new RecipeReference(stack));
        }
    }

    @Nullable
    protected TileEntityBanner.EnumBannerPattern func_179533_c(InventoryCrafting invCrafting) {
        for (TileEntityBanner.EnumBannerPattern pattern : TileEntityBanner.EnumBannerPattern.values()) {
            if (!advancedPatterns.containsKey(pattern)) continue;
            RecipeReference ref = advancedPatterns.get(pattern);
            boolean matchesPattern = true;
            boolean hasIngr = false;
            boolean hasColour = false;
            for (int i = 0; i < invCrafting.func_70302_i_() && matchesPattern; ++i) {
                ItemStack itemstack = invCrafting.func_70301_a(i);
                if (itemstack == null || itemstack.func_77973_b() == Items.field_179564_cE) continue;
                if (Utils.isDye(itemstack)) {
                    if (hasColour) {
                        matchesPattern = false;
                        break;
                    }
                    hasColour = true;
                    continue;
                }
                if (hasIngr || !ref.ingredient.matchesItemStack(itemstack)) {
                    matchesPattern = false;
                    break;
                }
                if (ref.offsetToBanner[0] != 0 || ref.offsetToBanner[1] != 0) {
                    int w = invCrafting.func_174922_i();
                    int h = invCrafting.func_174923_h();
                    int bannerSlot = i - ref.offsetToBanner[0] - ref.offsetToBanner[1] * w;
                    if (i % w == 0 && ref.offsetToBanner[0] > 0 || i % w == w - 1 && ref.offsetToBanner[0] < 0 || i / h == 0 && ref.offsetToBanner[1] > 0 || i / h == h - 1 && ref.offsetToBanner[1] < 0 || bannerSlot < 0 || bannerSlot >= invCrafting.func_70302_i_()) {
                        matchesPattern = false;
                        break;
                    }
                    ItemStack bannerCheck = invCrafting.func_70301_a(bannerSlot);
                    if (bannerCheck == null || bannerCheck.func_77973_b() != Items.field_179564_cE) {
                        matchesPattern = false;
                        break;
                    }
                }
                hasIngr = true;
            }
            if (!hasIngr) {
                matchesPattern = false;
            }
            if (!matchesPattern) continue;
            return pattern;
        }
        return null;
    }

    private static class RecipeReference {
        IngredientStack ingredient;
        int[] offsetToBanner = new int[2];

        public RecipeReference(IngredientStack ingredient) {
            this.ingredient = ingredient;
        }

        public RecipeReference(IngredientStack ingredient, int[] offsetToBanner) {
            this.ingredient = ingredient;
            this.offsetToBanner = offsetToBanner;
        }
    }
}

