/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeShapelessIngredient
extends ShapelessOreRecipe {
    static IngredientStack[] tempIngredients;
    List<IngredientStack> ingredients;
    int nbtCopyTargetSlot = -1;
    int toolDamageSlot = -1;

    public RecipeShapelessIngredient(ItemStack result, Object ... recipe) {
        super(result, RecipeShapelessIngredient.saveIngredients(recipe));
        this.setIngredients(tempIngredients);
        tempIngredients = null;
    }

    public RecipeShapelessIngredient setIngredients(IngredientStack[] ingr) {
        this.ingredients = new ArrayList<IngredientStack>();
        this.input.clear();
        for (IngredientStack stack : ingr) {
            if (stack == null) continue;
            this.ingredients.add(stack);
            this.input.add(stack.getShapedRecipeInput());
        }
        return this;
    }

    public List<IngredientStack> getIngredients() {
        return this.ingredients;
    }

    public RecipeShapelessIngredient setNBTCopyTargetRecipe(int slot) {
        this.nbtCopyTargetSlot = slot;
        return this;
    }

    public RecipeShapelessIngredient setToolDamageRecipe(int slot) {
        this.toolDamageSlot = slot;
        return this;
    }

    public static Object[] saveIngredients(Object ... recipe) {
        Object[] converted = new Object[recipe.length];
        tempIngredients = new IngredientStack[recipe.length];
        for (int i = 0; i < recipe.length; ++i) {
            IngredientStack ingr = ApiUtils.createIngredientStack(recipe[i]);
            if (ingr == null) continue;
            RecipeShapelessIngredient.tempIngredients[i] = ingr;
            converted[i] = Blocks.field_150480_ab;
        }
        return converted;
    }

    public ItemStack func_77572_b(InventoryCrafting matrix) {
        if (this.nbtCopyTargetSlot >= 0 && this.nbtCopyTargetSlot < this.ingredients.size()) {
            for (int i = 0; i < matrix.func_70302_i_(); ++i) {
                ItemStack slot = matrix.func_70301_a(i);
                if (!this.ingredients.get(this.nbtCopyTargetSlot).matchesItemStack(slot)) continue;
                ItemStack out = this.output.func_77946_l();
                if (matrix.func_70301_a(this.nbtCopyTargetSlot) != null && matrix.func_70301_a(this.nbtCopyTargetSlot).func_77942_o()) {
                    out.func_77982_d(matrix.func_70301_a(this.nbtCopyTargetSlot).func_77978_p().func_74737_b());
                }
                return out;
            }
        }
        return super.func_77572_b(matrix);
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        ItemStack[] remains = super.func_179532_b(inv);
        for (int i = 0; i < remains.length; ++i) {
            ItemStack empty;
            ItemStack s = inv.func_70301_a(i);
            ItemStack remain = remains[i];
            if (this.toolDamageSlot >= 0 && this.toolDamageSlot < this.ingredients.size()) {
                ItemStack tool = null;
                if (remain == null && s != null && this.ingredients.get(this.toolDamageSlot).matchesItemStack(s)) {
                    tool = s.func_77946_l();
                } else if (remain != null && this.ingredients.get(this.toolDamageSlot).matchesItemStack(remain)) {
                    tool = remain;
                }
                if (tool != null && tool.func_77973_b().func_77645_m()) {
                    tool.func_77964_b(tool.func_77952_i() + 1);
                    if (tool.func_77952_i() > tool.func_77958_k()) {
                        tool = null;
                    }
                    remains[i] = tool;
                }
            }
            if (s == null || remain != null || !(s.func_77973_b() instanceof UniversalBucket) || (empty = ((UniversalBucket)s.func_77973_b()).getEmpty()) == null) continue;
            remains[i] = empty.func_77946_l();
        }
        return remains;
    }

    public boolean func_77569_a(InventoryCrafting matrix, World world) {
        ArrayList<IngredientStack> required = new ArrayList<IngredientStack>(this.ingredients);
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            ItemStack slot = matrix.func_70301_a(i);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<IngredientStack> iterator = required.iterator();
            while (iterator.hasNext()) {
                IngredientStack next = iterator.next();
                if (!next.matchesItemStack(slot)) continue;
                inRecipe = true;
                iterator.remove();
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }
}

