/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.common.util.commands.CommandHelp;
import blusunrize.immersiveengineering.common.util.commands.CommandMineral;
import blusunrize.immersiveengineering.common.util.commands.CommandResetRenders;
import blusunrize.immersiveengineering.common.util.commands.CommandShaders;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandHandler
extends CommandBase {
    ArrayList<IESubCommand> commands = new ArrayList();
    final String name;

    public CommandHandler(boolean client) {
        this.commands.add(new CommandHelp());
        if (client) {
            this.commands.add(new CommandResetRenders());
            this.name = "cie";
        } else {
            this.commands.add(new CommandMineral());
            this.commands.add(new CommandShaders());
            this.name = "ie";
        }
    }

    public String func_71517_b() {
        return this.name;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length > 0) {
            for (IESubCommand sub : this.commands) {
                if (args.length == 1) {
                    if (!args[0].isEmpty() && !sub.getIdent().startsWith(args[0].toLowerCase())) continue;
                    list.add(sub.getIdent());
                    continue;
                }
                if (!sub.getIdent().equalsIgnoreCase(args[0])) continue;
                String[] redArgs = new String[args.length - 1];
                System.arraycopy(args, 1, redArgs, 0, redArgs.length);
                ArrayList<String> subCommands = sub.getSubCommands(this, server, redArgs);
                if (subCommands == null) continue;
                list.addAll(subCommands);
            }
        }
        return list;
    }

    public String func_71518_a(ICommandSender sender) {
        String sub = "";
        int i = 0;
        for (IESubCommand com : this.commands) {
            sub = sub + (i++ > 0 ? "|" : "") + com.getIdent();
        }
        return "/" + this.name + " <" + sub + ">";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length > 0) {
            for (IESubCommand com : this.commands) {
                if (!com.getIdent().equalsIgnoreCase(args[0])) continue;
                com.perform(this, server, sender, args);
            }
        } else {
            String sub = "";
            int i = 0;
            for (IESubCommand com : this.commands) {
                sub = sub + (i++ > 0 ? ", " : "") + com.getIdent();
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command.available", new Object[]{sub}));
        }
    }

    public static abstract class IESubCommand {
        public abstract String getIdent();

        public abstract void perform(CommandHandler var1, MinecraftServer var2, ICommandSender var3, String[] var4);

        public String getHelp(String subIdent) {
            return "chat.immersiveengineering.command." + this.getIdent() + subIdent + ".help";
        }

        public abstract ArrayList<String> getSubCommands(CommandHandler var1, MinecraftServer var2, String[] var3);
    }
}

