/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.common.util.commands.CommandHandler;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandHelp
extends CommandHandler.IESubCommand {
    @Override
    public String getIdent() {
        return "help";
    }

    @Override
    public void perform(CommandHandler handler, MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length > 1) {
            String sub = "";
            for (int i = 2; i < args.length; ++i) {
                sub = sub + "." + args[i];
            }
            for (CommandHandler.IESubCommand com : handler.commands) {
                if (!com.getIdent().equalsIgnoreCase(args[1])) continue;
                String h = I18n.func_135052_a((String)com.getHelp(sub), (Object[])new Object[0]);
                for (String s : h.split("<br>")) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(s));
                }
            }
        } else {
            String h = I18n.func_135052_a((String)this.getHelp(""), (Object[])new Object[0]);
            for (String s : h.split("<br>")) {
                sender.func_145747_a((ITextComponent)new TextComponentString(s));
            }
            String sub = "";
            int i = 0;
            for (CommandHandler.IESubCommand com : handler.commands) {
                sub = sub + (i++ > 0 ? ", " : "") + com.getIdent();
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command.available", new Object[]{sub}));
        }
    }

    @Override
    public ArrayList<String> getSubCommands(CommandHandler h, MinecraftServer server, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (CommandHandler.IESubCommand sub : h.commands) {
            if (sub == this) continue;
            if (args.length == 1) {
                if (!args[0].isEmpty() && !sub.getIdent().startsWith(args[0].toLowerCase())) continue;
                list.add(sub.getIdent());
                continue;
            }
            if (!sub.getIdent().equalsIgnoreCase(args[0])) continue;
            String[] redArgs = new String[args.length - 1];
            System.arraycopy(args, 1, redArgs, 0, redArgs.length);
            ArrayList<String> subCommands = sub.getSubCommands(h, server, redArgs);
            if (subCommands == null) continue;
            list.addAll(subCommands);
        }
        return list;
    }
}

