/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.commands.CommandHandler;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class CommandMineral
extends CommandHandler.IESubCommand {
    @Override
    public String getIdent() {
        return "mineral";
    }

    @Override
    public void perform(CommandHandler handler, MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length > 1) {
            DimensionChunkCoords coords = new DimensionChunkCoords(sender.func_130014_f_().field_73011_w.getDimension(), sender.func_180425_c().func_177958_n() >> 4, sender.func_180425_c().func_177952_p() >> 4);
            switch (args[1]) {
                case "list": {
                    String s = "";
                    int i = 0;
                    for (ExcavatorHandler.MineralMix mm : ExcavatorHandler.mineralList.keySet()) {
                        s = s + (i++ > 0 ? ", " : "") + mm.name;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString(s));
                    break;
                }
                case "get": {
                    ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(sender.func_130014_f_(), coords.field_77276_a, coords.field_77275_b);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".get", new Object[]{TextFormatting.GOLD + (info.mineral != null ? info.mineral.name : "null") + TextFormatting.RESET, TextFormatting.GOLD + (info.mineralOverride != null ? info.mineralOverride.name : "null") + TextFormatting.RESET, TextFormatting.GOLD + "" + info.depletion + TextFormatting.RESET}));
                    break;
                }
                case "set": {
                    ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(sender.func_130014_f_(), coords.field_77276_a, coords.field_77275_b);
                    if (args.length < 3) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".set.clear", new Object[]{info.mineralOverride != null ? info.mineralOverride.name : "null"}));
                        info.mineralOverride = null;
                        return;
                    }
                    ExcavatorHandler.MineralMix mineral = null;
                    for (ExcavatorHandler.MineralMix mm : ExcavatorHandler.mineralList.keySet()) {
                        if (!mm.name.equalsIgnoreCase(args[2])) continue;
                        mineral = mm;
                    }
                    if (mineral == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".set.invalidMineral", new Object[]{args[2]}));
                        return;
                    }
                    info.mineralOverride = mineral;
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".set.sucess", new Object[]{mineral.name}));
                    IESaveData.setDirty(sender.func_130014_f_().field_73011_w.getDimension());
                    break;
                }
                case "setDepletion": {
                    ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(sender.func_130014_f_(), coords.field_77276_a, coords.field_77275_b);
                    if (args.length < 3) {
                        String h = I18n.func_135052_a((String)this.getHelp(".setDepletion"), (Object[])new Object[0]);
                        for (String str : h.split("<br>")) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(str));
                        }
                        return;
                    }
                    int depl = 0;
                    try {
                        depl = Integer.parseInt(args[2].trim());
                    }
                    catch (Exception e) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".setDepletion.NFE", new Object[]{args[2].trim()}));
                        return;
                    }
                    info.depletion = depl;
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + this.getIdent() + ".setDepletion.sucess", new Object[]{depl < 0 ? I18n.func_135052_a((String)"chat.immersiveengineering.info.coreDrill.infinite", (Object[])new Object[0]) : Integer.toString(depl)}));
                    IESaveData.setDirty(sender.func_130014_f_().field_73011_w.getDimension());
                    break;
                }
                default: {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.getHelp(""), new Object[0]));
                    break;
                }
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.getHelp(""), new Object[0]));
        }
    }

    @Override
    public ArrayList<String> getSubCommands(CommandHandler h, MinecraftServer server, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length > 1) {
            switch (args[0]) {
                case "set": {
                    if (args.length > 2) break;
                    for (ExcavatorHandler.MineralMix mineralMix : ExcavatorHandler.mineralList.keySet()) {
                        if (!args[1].isEmpty() && !mineralMix.name.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        list.add(mineralMix.name);
                    }
                    break;
                }
            }
            return list;
        }
        for (String s : new String[]{"list", "get", "set", "setDepletion"}) {
            if (args.length == 0) {
                list.add(s);
                continue;
            }
            if (!s.toLowerCase().startsWith(args[0].toLowerCase())) continue;
            list.add(s);
        }
        return list;
    }
}

