/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.compat.BaublesHelper;
import blusunrize.immersiveengineering.common.util.compat.BloodMagicHelper;
import blusunrize.immersiveengineering.common.util.compat.BotaniaHelper;
import blusunrize.immersiveengineering.common.util.compat.ChiselHelper;
import blusunrize.immersiveengineering.common.util.compat.ChiselsAndBitsHelper;
import blusunrize.immersiveengineering.common.util.compat.DenseOresHelper;
import blusunrize.immersiveengineering.common.util.compat.EnderIOHelper;
import blusunrize.immersiveengineering.common.util.compat.FoundryHelper;
import blusunrize.immersiveengineering.common.util.compat.IC2Helper;
import blusunrize.immersiveengineering.common.util.compat.TConstructHelper;
import blusunrize.immersiveengineering.common.util.compat.ThaumcraftHelper;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.OCHelper;
import blusunrize.immersiveengineering.common.util.compat.waila.WailaHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class IECompatModule {
    public static HashMap<String, Class<? extends IECompatModule>> moduleClasses = new HashMap();
    public static Set<IECompatModule> modules = new HashSet<IECompatModule>();
    public static boolean serverStartingDone;

    public static void doModulesPreInit() {
        for (Map.Entry<String, Class<? extends IECompatModule>> e : moduleClasses.entrySet()) {
            if (!Loader.isModLoaded((String)e.getKey()) || !Config.getBoolean("compat_" + e.getKey())) continue;
            try {
                IECompatModule m = e.getValue().newInstance();
                modules.add(m);
                m.preInit();
            }
            catch (Exception exception) {
                IELogger.error("Compat module for " + e.getKey() + " could not be preInitialized. Report this!");
            }
        }
    }

    public static void doModulesInit() {
        for (IECompatModule compat : modules) {
            try {
                compat.init();
            }
            catch (Exception exception) {
                IELogger.error("Compat module for " + compat + " could not be initialized");
            }
        }
    }

    public static void doModulesPostInit() {
        for (IECompatModule compat : modules) {
            try {
                compat.postInit();
            }
            catch (Exception exception) {
                IELogger.error("Compat module for " + compat + " could not be initialized");
            }
        }
    }

    public static void doModulesLoadComplete() {
        if (!serverStartingDone) {
            serverStartingDone = true;
            for (IECompatModule compat : modules) {
                try {
                    compat.loadComplete();
                }
                catch (Exception exception) {
                    IELogger.error("Compat module for " + compat + " could not be initialized");
                    exception.printStackTrace();
                }
            }
        }
    }

    public abstract void preInit();

    public abstract void init();

    public abstract void postInit();

    public void loadComplete() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPreInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPostInit() {
    }

    static {
        moduleClasses.put("Baubles", BaublesHelper.class);
        moduleClasses.put("Botania", BotaniaHelper.class);
        moduleClasses.put("BloodMagic", BloodMagicHelper.class);
        moduleClasses.put("chisel", ChiselHelper.class);
        moduleClasses.put("chiselsandbits", ChiselsAndBitsHelper.class);
        moduleClasses.put("denseores", DenseOresHelper.class);
        moduleClasses.put("EnderIO", EnderIOHelper.class);
        moduleClasses.put("foundry", FoundryHelper.class);
        moduleClasses.put("IC2", IC2Helper.class);
        moduleClasses.put("OpenComputers", OCHelper.class);
        moduleClasses.put("Thaumcraft", ThaumcraftHelper.class);
        moduleClasses.put("tconstruct", TConstructHelper.class);
        moduleClasses.put("Waila", WailaHelper.class);
        moduleClasses.put("MineTweaker3", CraftTweakerHelper.class);
        serverStartingDone = false;
    }
}

