/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.BlastFurnace")
public class BlastFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int time, @Optional IItemStack slag) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        BlastFurnaceRecipe r = new BlastFurnaceRecipe(CraftTweakerHelper.toStack(output), oInput, time, CraftTweakerHelper.toStack(slag));
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    @ZenMethod
    public static void addFuel(IIngredient input, int time) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(oInput, time));
    }

    @ZenMethod
    public static void removeFuel(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(CraftTweakerHelper.toStack(output)));
    }

    private static class RemoveFuel
    implements IUndoableAction {
        private final ItemStack stack;
        Object ident;
        int removedTime;

        public RemoveFuel(ItemStack fuel) {
            this.stack = fuel;
        }

        public void apply() {
            Set<Map.Entry<Object, Integer>> set = BlastFurnaceRecipe.blastFuels.entrySet();
            Iterator<Map.Entry<Object, Integer>> it = set.iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Integer> e = it.next();
                if (!ApiUtils.stackMatchesObject(this.stack, e.getKey())) continue;
                this.removedTime = e.getValue();
                this.ident = e.getKey();
                it.remove();
                break;
            }
        }

        public void undo() {
            if (this.ident != null) {
                BlastFurnaceRecipe.blastFuels.put(this.ident, this.removedTime);
            }
        }

        public String describe() {
            return "Removing " + this.stack + " as Blast Furnace Fuel";
        }

        public String describeUndo() {
            return "Re-Adding " + this.stack + " as Blast Furnace Fuel";
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class AddFuel
    implements IUndoableAction {
        private final Object fuel;
        private final int burnTime;

        public AddFuel(Object fuel, int burnTime) {
            this.fuel = fuel;
            this.burnTime = burnTime;
        }

        public void apply() {
            BlastFurnaceRecipe.addBlastFuel(this.fuel, this.burnTime);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BlastFurnaceRecipe.blastFuels.remove(ApiUtils.convertToValidRecipeInput(this.fuel));
        }

        public String describe() {
            return "Adding " + (this.fuel instanceof ItemStack ? ((ItemStack)this.fuel).func_82833_r() : (String)this.fuel) + " as Blast Furnace Fuel";
        }

        public String describeUndo() {
            return "Removing " + (this.fuel instanceof ItemStack ? ((ItemStack)this.fuel).func_82833_r() : (String)this.fuel) + " as Blast Furnace Fuel";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<BlastFurnaceRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = BlastFurnaceRecipe.removeRecipes(this.output);
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (BlastFurnaceRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    BlastFurnaceRecipe.recipeList.add(recipe);
                }
            }
        }

        public String describe() {
            return "Removing Blast Furnace Recipe for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding Blast Furnace Recipe for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final BlastFurnaceRecipe recipe;

        public Add(BlastFurnaceRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            BlastFurnaceRecipe.recipeList.add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BlastFurnaceRecipe.recipeList.remove(this.recipe);
        }

        public String describe() {
            return "Adding Blast Furnace Recipe for " + this.recipe.output.func_82833_r();
        }

        public String describeUndo() {
            return "Removing Blast Furnace Recipe for " + this.recipe.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

