/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import java.util.ArrayList;
import java.util.Iterator;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Refinery")
public class Refinery {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack input0, ILiquidStack input1) {
        if (CraftTweakerHelper.toFluidStack(input0) == null || CraftTweakerHelper.toFluidStack(input0).getFluid() == null) {
            return;
        }
        if (CraftTweakerHelper.toFluidStack(input1) == null || CraftTweakerHelper.toFluidStack(input1).getFluid() == null) {
            return;
        }
        if (CraftTweakerHelper.toFluidStack(output) == null || CraftTweakerHelper.toFluidStack(output).getFluid() == null) {
            return;
        }
        DieselHandler.RefineryRecipe r = new DieselHandler.RefineryRecipe(CraftTweakerHelper.toFluidStack(input0), CraftTweakerHelper.toFluidStack(input1), CraftTweakerHelper.toFluidStack(output));
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output) {
        if (CraftTweakerHelper.toFluidStack(output) != null) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(CraftTweakerHelper.toFluidStack(output)));
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final FluidStack output;
        ArrayList<DieselHandler.RefineryRecipe> removedRecipes = new ArrayList();

        public Remove(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<DieselHandler.RefineryRecipe> it = DieselHandler.refineryList.iterator();
            while (it.hasNext()) {
                DieselHandler.RefineryRecipe r = it.next();
                if (r == null || !r.output.isFluidEqual(this.output)) continue;
                this.removedRecipes.add(r);
                it.remove();
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (DieselHandler.RefineryRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    DieselHandler.refineryList.add(recipe);
                }
            }
        }

        public String describe() {
            return "Removing Refinery Recipes for " + this.output.getLocalizedName();
        }

        public String describeUndo() {
            return "Re-Adding Refinery Recipes for " + this.output.getLocalizedName();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final DieselHandler.RefineryRecipe recipe;

        public Add(DieselHandler.RefineryRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            DieselHandler.refineryList.add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            DieselHandler.refineryList.remove(this.recipe);
        }

        public String describe() {
            return "Adding Refinery Recipe for " + this.recipe.output.getLocalizedName();
        }

        public String describeUndo() {
            return "Removing Refinery Recipe for " + this.recipe.output.getLocalizedName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

