/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.opencomputers;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CrusherDriver
extends DriverSidedTileEntity {
    public ManagedEnvironment createEnvironment(World w, BlockPos bp, EnumFacing facing) {
        TileEntityCrusher crush;
        TileEntityCrusher master;
        TileEntity te = w.func_175625_s(bp);
        if (te instanceof TileEntityCrusher && (master = (TileEntityCrusher)(crush = (TileEntityCrusher)te).master()) != null && crush.isRedstonePos()) {
            return new CrusherEnvironment(w, master.func_174877_v(), TileEntityCrusher.class);
        }
        return null;
    }

    public Class<?> getTileEntityClass() {
        return TileEntityCrusher.class;
    }

    public class CrusherEnvironment
    extends ManagedEnvironmentIE<TileEntityCrusher> {
        public CrusherEnvironment(World w, BlockPos bp, Class<? extends TileEntityIEBase> teClass) {
            super(w, bp, teClass);
        }

        @Callback(doc="function(enable:boolean) -- enable or disable the crusher")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityCrusher)this.getTileEntity()).computerOn = args.checkBoolean(0);
            return null;
        }

        @Callback(doc="function():number -- get energy storage capacity")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityCrusher)this.getTileEntity()).energyStorage.getEnergyStored()};
        }

        @Callback(doc="function():number -- get currently stored energy")
        public Object[] getMaxEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityCrusher)this.getTileEntity()).energyStorage.getMaxEnergyStored()};
        }

        @Callback(doc="function():boolean -- get whether the crusher is currently crushing items")
        public Object[] isActive(Context context, Arguments args) {
            return new Object[]{((TileEntityCrusher)this.getTileEntity()).shouldRenderAsActive()};
        }

        @Callback(doc="function():table -- returns the entire input queue of the crusher")
        public Object[] getInputQueue(Context context, Arguments args) {
            TileEntityCrusher master = (TileEntityCrusher)this.getTileEntity();
            HashMap ret = new HashMap();
            List queue = master.processQueue;
            for (int i = 0; i < queue.size(); ++i) {
                TileEntityMultiblockMetal.MultiblockProcess currTmp = (TileEntityMultiblockMetal.MultiblockProcess)queue.get(i);
                if (!(currTmp instanceof TileEntityMultiblockMetal.MultiblockProcessInWorld)) continue;
                TileEntityMultiblockMetal.MultiblockProcessInWorld curr = (TileEntityMultiblockMetal.MultiblockProcessInWorld)currTmp;
                HashMap<String, Object> recipe = new HashMap<String, Object>();
                recipe.put("progress", curr.processTick);
                recipe.put("maxProgress", curr.maxTicks);
                Map<String, Object> input = Utils.saveStack(curr.inputItem);
                recipe.put("input", input);
                recipe.put("output", Utils.saveStack(((CrusherRecipe)curr.recipe).output));
                ret.put(i + 1, recipe);
            }
            return new Object[]{ret};
        }

        public String preferredName() {
            return "ie_crusher";
        }

        public int priority() {
            return 1000;
        }

        public void onConnect(Node node) {
            TileEntityCrusher te = (TileEntityCrusher)this.getTileEntity();
            if (te != null) {
                ++te.controllingComputers;
                te.computerOn = true;
            }
        }

        public void onDisconnect(Node node) {
            TileEntityCrusher te = (TileEntityCrusher)this.getTileEntity();
            if (te != null) {
                --te.controllingComputers;
            }
        }
    }
}

