/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageTileSync
implements IMessage {
    int dimension;
    BlockPos pos;
    NBTTagCompound nbt;

    public MessageTileSync(TileEntityIEBase tile, NBTTagCompound nbt) {
        this.dimension = tile.func_145831_w().field_73011_w.getDimension();
        this.pos = tile.func_174877_v();
        this.nbt = nbt;
    }

    public MessageTileSync() {
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public static class HandlerClient
    implements IMessageHandler<MessageTileSync, IMessage> {
        public IMessage onMessage(MessageTileSync message, MessageContext ctx) {
            TileEntity tile;
            World world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null && (tile = world.func_175625_s(message.pos)) instanceof TileEntityIEBase) {
                ((TileEntityIEBase)tile).receiveMessageFromServer(message.nbt);
            }
            return null;
        }
    }

    public static class HandlerServer
    implements IMessageHandler<MessageTileSync, IMessage> {
        public IMessage onMessage(MessageTileSync message, MessageContext ctx) {
            TileEntity tile;
            WorldServer world = DimensionManager.getWorld((int)message.dimension);
            if (world != null && (tile = world.func_175625_s(message.pos)) instanceof TileEntityIEBase) {
                ((TileEntityIEBase)tile).receiveMessageFromClient(message.nbt);
            }
            return null;
        }
    }
}

