/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.crosshair;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.crosshair.ICrosshair;
import slimeknights.tconstruct.library.client.crosshair.ICustomCrosshairUser;

@SideOnly(value=Side.CLIENT)
public final class CrosshairRenderEvents {
    public static final CrosshairRenderEvents INSTANCE = new CrosshairRenderEvents();
    private static final Minecraft mc = Minecraft.func_71410_x();

    private CrosshairRenderEvents() {
    }

    @SubscribeEvent
    public void onCrosshairRender(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        EntityPlayerSP entityPlayer = CrosshairRenderEvents.mc.field_71439_g;
        ItemStack itemStack = this.getItemstack((EntityPlayer)entityPlayer);
        if (itemStack == null) {
            return;
        }
        ICustomCrosshairUser customCrosshairUser = (ICustomCrosshairUser)itemStack.func_77973_b();
        ICrosshair crosshair = customCrosshairUser.getCrosshair(itemStack, (EntityPlayer)entityPlayer);
        if (crosshair == ICrosshair.DEFAULT) {
            return;
        }
        float width = event.getResolution().func_78326_a();
        float height = event.getResolution().func_78328_b();
        crosshair.render(customCrosshairUser.getCrosshairState(itemStack, (EntityPlayer)entityPlayer), width, height, event.getPartialTicks());
        event.setCanceled(true);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    private ItemStack getItemstack(EntityPlayer entityPlayer) {
        ItemStack itemStack = null;
        if (entityPlayer.func_184587_cr() && this.isValidItem(entityPlayer.func_184607_cu())) {
            itemStack = entityPlayer.func_184607_cu();
        }
        if (itemStack == null && this.isValidItem(entityPlayer.func_184614_ca())) {
            itemStack = entityPlayer.func_184614_ca();
        }
        if (itemStack == null && this.isValidItem(entityPlayer.func_184592_cb())) {
            itemStack = entityPlayer.func_184592_cb();
        }
        return itemStack;
    }

    private boolean isValidItem(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof ICustomCrosshairUser;
    }
}

