/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.collect.ImmutableList;
import java.util.List;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;

public class BowMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_Drawspeed = "stat.bow.drawspeed.name";
    public static final String LOC_Range = "stat.bow.range.name";
    public static final String LOC_DrawspeedDesc = "stat.bow.drawspeed.desc";
    public static final String LOC_RangeDesc = "stat.bow.range.desc";
    public static final String COLOR_Drawspeed = CustomFontColor.encodeColor(225, 225, 225);
    public static final String COLOR_Range = CustomFontColor.encodeColor(150, 205, 205);
    public final float drawspeed;
    public final float range;

    public BowMaterialStats(float drawspeed, float range) {
        super("bow");
        this.drawspeed = drawspeed;
        this.range = range;
    }

    public static String formatDrawspeed(float drawspeed) {
        return BowMaterialStats.formatNumber(LOC_Drawspeed, COLOR_Drawspeed, drawspeed);
    }

    public static String formatRange(float range) {
        return BowMaterialStats.formatNumber(LOC_Range, COLOR_Range, range);
    }

    @Override
    public List<String> getLocalizedInfo() {
        return ImmutableList.of((Object)BowMaterialStats.formatDrawspeed(this.drawspeed), (Object)BowMaterialStats.formatRange(this.range));
    }

    @Override
    public List<String> getLocalizedDesc() {
        return ImmutableList.of((Object)Util.translate(LOC_DrawspeedDesc, new Object[0]), (Object)Util.translate(LOC_RangeDesc, new Object[0]));
    }
}

