/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.mantle.util.RecipeMatchRegistry;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.traits.ITrait;

public class Material
extends RecipeMatchRegistry {
    public static final Material UNKNOWN = new Material("unknown", TextFormatting.WHITE);
    public static final String LOC_Name = "material.%s.name";
    public static final String LOC_Prefix = "material.%s.prefix";
    public static final int VALUE_Ingot = 144;
    public static final int VALUE_Nugget = 16;
    public static final int VALUE_Fragment = 36;
    public static final int VALUE_Shard = 72;
    public static final int VALUE_Gem = 666;
    public static final int VALUE_Block = 1296;
    public static final int VALUE_SearedBlock = 288;
    public static final int VALUE_SearedMaterial = 72;
    public static final int VALUE_Glass = 1000;
    public static final int VALUE_BrickBlock = 576;
    public static final int VALUE_SlimeBall = 250;
    public final String identifier;
    protected Fluid fluid;
    protected boolean craftable;
    protected boolean castable;
    @SideOnly(value=Side.CLIENT)
    public MaterialRenderInfo renderInfo;
    public int materialTextColor = 0xFFFFFF;
    private ItemStack representativeItem;
    private ItemStack shardItem;
    protected final Map<String, IMaterialStats> stats = new LinkedHashMap<String, IMaterialStats>();
    protected final Map<String, List<ITrait>> traits = new LinkedHashMap<String, List<ITrait>>();

    public static int VALUE_Ore() {
        return (int)(144.0 * Config.oreToIngotRatio);
    }

    public Material(String identifier, TextFormatting textColor) {
        this(identifier, Util.enumChatFormattingToColor(textColor));
    }

    public Material(String identifier, int color) {
        this.identifier = Util.sanitizeLocalizationString(identifier);
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        this.materialTextColor = color;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.setRenderInfo(color);
        }
    }

    public boolean isHidden() {
        return false;
    }

    public Material setFluid(Fluid fluid) {
        if (fluid != null && !FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            TinkerRegistry.log.warn("Materials cannot have an unregistered fluid associated with them!");
        }
        this.fluid = fluid;
        return this;
    }

    public Material setCraftable(boolean craftable) {
        this.craftable = craftable;
        return this;
    }

    public boolean isCraftable() {
        return this.craftable || Config.craftCastableMaterials && this.castable;
    }

    public Material setCastable(boolean castable) {
        this.castable = castable;
        return this;
    }

    public boolean isCastable() {
        return this.hasFluid() && this.castable;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRenderInfo(MaterialRenderInfo renderInfo) {
        this.renderInfo = renderInfo;
    }

    @SideOnly(value=Side.CLIENT)
    public MaterialRenderInfo setRenderInfo(int color) {
        this.setRenderInfo(new MaterialRenderInfo.Default(color));
        return this.renderInfo;
    }

    public Material addStats(IMaterialStats materialStats) {
        this.stats.put(materialStats.getIdentifier(), materialStats);
        return this;
    }

    private IMaterialStats getStatsSafe(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return null;
        }
        for (IMaterialStats stat : this.stats.values()) {
            if (!identifier.equals(stat.getIdentifier())) continue;
            return stat;
        }
        return null;
    }

    public <T extends IMaterialStats> T getStats(String identifier) {
        return (T)this.getStatsSafe(identifier);
    }

    public <T extends IMaterialStats> T getStatsOrUnknown(String identifier) {
        IMaterialStats stats = this.getStatsSafe(identifier);
        if (stats == null && this != UNKNOWN) {
            return UNKNOWN.getStats(identifier);
        }
        return (T)stats;
    }

    public Collection<IMaterialStats> getAllStats() {
        return this.stats.values();
    }

    public boolean hasStats(String identifier) {
        return this.getStats(identifier) != null;
    }

    public Material addTrait(ITrait materialTrait) {
        return this.addTrait(materialTrait, null);
    }

    public Material addTrait(ITrait materialTrait, String dependency) {
        if (TinkerRegistry.checkMaterialTrait(this, materialTrait, dependency)) {
            this.getStatTraits(dependency).add(materialTrait);
        }
        return this;
    }

    protected List<ITrait> getStatTraits(String id) {
        if (!this.traits.containsKey(id)) {
            this.traits.put(id, new LinkedList());
        }
        return this.traits.get(id);
    }

    public boolean hasTrait(String identifier, String stats) {
        if (identifier == null || identifier.isEmpty()) {
            return false;
        }
        for (ITrait trait : this.getStatTraits(stats)) {
            if (!trait.getIdentifier().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    public List<ITrait> getDefaultTraits() {
        return ImmutableList.copyOf(this.getStatTraits(null));
    }

    public List<ITrait> getAllTraitsForStats(String stats) {
        if (this.traits.containsKey(stats)) {
            return ImmutableList.copyOf((Collection)this.traits.get(stats));
        }
        if (this.traits.containsKey(null)) {
            return ImmutableList.copyOf((Collection)this.traits.get(null));
        }
        return ImmutableList.of();
    }

    public Collection<ITrait> getAllTraits() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (List<ITrait> traitlist : this.traits.values()) {
            builder.addAll(traitlist);
        }
        return builder.build();
    }

    public boolean hasFluid() {
        return this.fluid != null;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public void addItemIngot(String oredict) {
        this.addItem(oredict, 1, 144);
    }

    public void setRepresentativeItem(Item representativeItem) {
        this.setRepresentativeItem(new ItemStack(representativeItem));
    }

    public void setRepresentativeItem(Block representativeBlock) {
        this.setRepresentativeItem(new ItemStack(representativeBlock));
    }

    public void setRepresentativeItem(ItemStack representativeItem) {
        if (representativeItem == null) {
            this.representativeItem = null;
        } else if (this.matches(new ItemStack[]{representativeItem}) != null) {
            this.representativeItem = representativeItem;
        } else {
            TinkerRegistry.log.warn("Itemstack {} cannot represent material {} since it is not associated with the material!", new Object[]{representativeItem.toString(), this.identifier});
        }
    }

    public ItemStack getRepresentativeItem() {
        return this.representativeItem;
    }

    public void setShard(Item item) {
        this.setShard(new ItemStack(item));
    }

    public void setShard(ItemStack stack) {
        if (stack == null) {
            this.shardItem = null;
        } else {
            RecipeMatch.Match match = this.matches(new ItemStack[]{stack});
            if (match != null) {
                if (match.amount == 72) {
                    this.shardItem = stack;
                } else {
                    TinkerRegistry.log.warn("Itemstack {} cannot be shard of material {} since it does not have the correct value! (is {}, has to be {})", new Object[]{this.representativeItem.toString(), this.identifier, match.amount, 72});
                }
            } else {
                TinkerRegistry.log.warn("Itemstack {} cannot be shard of material {} since it is not associated with the material!", new Object[]{stack.toString(), this.identifier});
            }
        }
    }

    public ItemStack getShard() {
        if (this.shardItem != null) {
            return this.shardItem.func_77946_l();
        }
        return null;
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    public String getLocalizedName() {
        return Util.translate(LOC_Name, this.getIdentifier());
    }

    public String getLocalizedItemName(String itemName) {
        if (this == UNKNOWN) {
            return itemName;
        }
        if (I18n.func_94522_b((String)String.format(LOC_Prefix, this.getIdentifier()))) {
            return I18n.func_74837_a((String)String.format(LOC_Prefix, Util.sanitizeLocalizationString(this.identifier)), (Object[])new Object[]{itemName});
        }
        return this.getLocalizedName() + " " + itemName;
    }

    public String getLocalizedNameColored() {
        return this.getTextColor() + this.getLocalizedName();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getTextColor() {
        return CustomFontColor.encodeColor(this.materialTextColor);
    }

    static {
        UNKNOWN.addStats(new HeadMaterialStats(1, 1.0f, 1.0f, 0));
        UNKNOWN.addStats(new HandleMaterialStats(1.0f, 0));
        UNKNOWN.addStats(new ExtraMaterialStats(0));
        UNKNOWN.addStats(new BowMaterialStats(4.0f, 10.0f));
        UNKNOWN.addStats(new BowStringMaterialStats(1.0f));
        UNKNOWN.addStats(new ArrowShaftMaterialStats(1.0f, 0));
        UNKNOWN.addStats(new FletchingMaterialStats(1.0f, 1.0f));
    }
}

