/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.smeltery.SmelteryClientEvents;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockSearedGlass;
import slimeknights.tconstruct.smeltery.block.BlockSmelteryIO;
import slimeknights.tconstruct.smeltery.block.BlockTank;
import slimeknights.tconstruct.smeltery.client.CastingRenderer;
import slimeknights.tconstruct.smeltery.client.FaucetRenderer;
import slimeknights.tconstruct.smeltery.client.SmelteryRenderer;
import slimeknights.tconstruct.smeltery.client.TankRenderer;
import slimeknights.tconstruct.smeltery.client.TinkerTankRenderer;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingBasin;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingTable;
import slimeknights.tconstruct.smeltery.tileentity.TileFaucet;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;
import slimeknights.tconstruct.smeltery.tileentity.TileTinkerTank;

public class SmelteryClientProxy
extends ClientProxy {
    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new SmelteryClientEvents());
    }

    @Override
    protected void registerModels() {
        ModelLoader.setCustomStateMapper((Block)TinkerSmeltery.searedGlass, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSearedGlass.TYPE}).func_178441_a());
        this.registerItemModel((Block)TinkerSmeltery.smelteryController);
        this.registerItemModel((Block)TinkerSmeltery.faucet);
        this.registerItemModel(TinkerSmeltery.searedGlass);
        this.registerItemModel(TinkerSmeltery.searedFurnaceController);
        this.registerItemModel(TinkerSmeltery.tinkerTankController);
        this.registerItemBlockMeta((Block)TinkerSmeltery.searedBlock);
        this.registerItemBlockMeta((Block)TinkerSmeltery.castingBlock);
        this.registerItemBlockMeta(TinkerSmeltery.searedSlab);
        this.registerItemBlockMeta(TinkerSmeltery.searedSlab2);
        this.registerItemModel(TinkerSmeltery.searedStairsStone);
        this.registerItemModel(TinkerSmeltery.searedStairsCobble);
        this.registerItemModel(TinkerSmeltery.searedStairsPaver);
        this.registerItemModel(TinkerSmeltery.searedStairsBrick);
        this.registerItemModel(TinkerSmeltery.searedStairsBrickCracked);
        this.registerItemModel(TinkerSmeltery.searedStairsBrickFancy);
        this.registerItemModel(TinkerSmeltery.searedStairsBrickSquare);
        this.registerItemModel(TinkerSmeltery.searedStairsBrickTriangle);
        this.registerItemModel(TinkerSmeltery.searedStairsBrickSmall);
        this.registerItemModel(TinkerSmeltery.searedStairsRoad);
        this.registerItemModel(TinkerSmeltery.searedStairsTile);
        this.registerItemModel(TinkerSmeltery.searedStairsCreeper);
        Item drain = Item.func_150898_a((Block)TinkerSmeltery.smelteryIO);
        for (BlockSmelteryIO.IOType type : BlockSmelteryIO.IOType.values()) {
            String variant = String.format("%s=%s,%s=%s", BlockSmelteryIO.FACING.func_177701_a(), BlockSmelteryIO.FACING.func_177702_a((Enum)EnumFacing.SOUTH), BlockSmelteryIO.TYPE.func_177701_a(), BlockSmelteryIO.TYPE.func_177702_a((Enum)type));
            ModelLoader.setCustomModelResourceLocation((Item)drain, (int)type.meta, (ModelResourceLocation)new ModelResourceLocation(drain.getRegistryName(), variant));
        }
        Item tank = Item.func_150898_a((Block)TinkerSmeltery.searedTank);
        for (BlockTank.TankType type : BlockTank.TankType.values()) {
            String variant = String.format("%s=%s,%s=%s", BlockTank.KNOB.func_177701_a(), BlockTank.KNOB.func_177702_a(Boolean.valueOf(type == BlockTank.TankType.TANK)), BlockTank.TYPE.func_177701_a(), BlockTank.TYPE.func_177702_a((Enum)type));
            ModelLoader.setCustomModelResourceLocation((Item)tank, (int)type.meta, (ModelResourceLocation)new ModelResourceLocation(tank.getRegistryName(), variant));
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileTank.class, (TileEntitySpecialRenderer)new TankRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSmeltery.class, (TileEntitySpecialRenderer)new SmelteryRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTinkerTank.class, (TileEntitySpecialRenderer)new TinkerTankRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileFaucet.class, (TileEntitySpecialRenderer)new FaucetRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCastingTable.class, (TileEntitySpecialRenderer)new CastingRenderer.Table());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCastingBasin.class, (TileEntitySpecialRenderer)new CastingRenderer.Basin());
        ResourceLocation castLoc = SmelteryClientEvents.locBlankCast;
        CustomTextureCreator.castModelLocation = new ResourceLocation(castLoc.func_110624_b(), "item/" + castLoc.func_110623_a());
        ModelLoader.setCustomMeshDefinition((Item)TinkerSmeltery.cast, (ItemMeshDefinition)new ClientProxy.PatternMeshDefinition(castLoc));
        if (Config.claycasts) {
            ResourceLocation clayCastLoc = SmelteryClientEvents.locClayCast;
            CustomTextureCreator.castModelLocation = new ResourceLocation(clayCastLoc.func_110624_b(), "item/" + clayCastLoc.func_110623_a());
            ModelLoader.setCustomMeshDefinition((Item)TinkerSmeltery.clayCast, (ItemMeshDefinition)new ClientProxy.PatternMeshDefinition(clayCastLoc));
        }
        TinkerSmeltery.castCustom.registerItemModels();
    }
}

