/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.block.PropertyTableItem;
import slimeknights.tconstruct.shared.tileentity.TileTable;
import slimeknights.tconstruct.tools.common.client.GuiCraftingStation;
import slimeknights.tconstruct.tools.common.inventory.ContainerCraftingStation;

public class TileCraftingStation
extends TileTable
implements IInventoryGui {
    public TileCraftingStation() {
        super("gui.craftingstation.name", 9);
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerCraftingStation(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiCraftingStation(inventoryplayer, world, pos, this);
    }

    @Override
    protected IExtendedBlockState setInventoryDisplay(IExtendedBlockState state) {
        PropertyTableItem.TableItems toDisplay = new PropertyTableItem.TableItems();
        float s = 0.125f;
        float o = 0.1875f;
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            PropertyTableItem.TableItem item = TileCraftingStation.getTableItem(itemStack, this.field_145850_b, null);
            if (item == null) continue;
            item.x = o - (float)(i % 3) * o;
            item.z = o - (float)(i / 3) * o;
            item.y = -0.5f + s / 32.0f;
            item.s = s;
            if (itemStack.func_77973_b() instanceof ItemBlock && !(Block.func_149634_a((Item)itemStack.func_77973_b()) instanceof BlockPane)) {
                item.y = -(1.0f - item.s) / 2.0f;
            }
            toDisplay.items.add(item);
        }
        return state.withProperty((IUnlistedProperty)BlockTable.INVENTORY, (Object)toDisplay);
    }
}

