/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;

public class ModLuck
extends ModifierTrait {
    protected static final int baseCount = 60;
    protected static final int maxLevel = 3;
    private final LuckAspect aspect;

    public ModLuck() {
        super("luck", 2970082, 3, 0);
        this.aspects.clear();
        this.aspect = new LuckAspect(this);
        this.addAspects(this.aspect);
    }

    public int getLuckLevel(ItemStack itemStack) {
        return this.getLuckLevel(TinkerUtil.getModifierTag(itemStack, this.getModifierIdentifier()));
    }

    public int getLuckLevel(NBTTagCompound modifierTag) {
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
        return this.aspect.getLevel(data.current);
    }

    @Override
    public boolean canApplyTogether(Enchantment enchantment) {
        return enchantment != Enchantments.field_185306_r;
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        int lvl = this.getLuckLevel(modifierTag);
        this.applyEnchantments(rootCompound, lvl);
    }

    @Override
    public void afterBlockBreak(ItemStack tool, World world, IBlockState state, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        this.rewardProgress(tool);
    }

    @Override
    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (player.field_70170_p.field_72995_K || !wasHit) {
            return;
        }
        for (int i = (int)(damageDealt / 2.0f); i > 0; --i) {
            this.rewardProgress(tool);
        }
    }

    public void rewardProgress(ItemStack tool) {
        if (random.nextFloat() > 0.02f) {
            return;
        }
        try {
            if (this.canApply(tool, tool)) {
                this.apply(tool);
            }
        }
        catch (TinkerGuiException tinkerGuiException) {
            // empty catch block
        }
    }

    protected void applyEnchantments(NBTTagCompound rootCompound, int lvl) {
        boolean harvest = false;
        boolean weapon = false;
        lvl = Math.min(lvl, Enchantments.field_185304_p.func_77325_b());
        for (Category category : TagUtil.getCategories(rootCompound)) {
            if (category == Category.HARVEST) {
                harvest = true;
            }
            if (category != Category.WEAPON) continue;
            weapon = true;
        }
        if (weapon) {
            while (lvl > ToolBuilder.getEnchantmentLevel(rootCompound, Enchantments.field_185304_p)) {
                ToolBuilder.addEnchantment(rootCompound, Enchantments.field_185304_p);
            }
        }
        if (harvest) {
            while (lvl > ToolBuilder.getEnchantmentLevel(rootCompound, Enchantments.field_185308_t)) {
                ToolBuilder.addEnchantment(rootCompound, Enchantments.field_185308_t);
            }
        }
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        int level = this.getLuckLevel(modifierTag);
        String tooltip = this.getLocalizedName();
        if (level > 0) {
            tooltip = tooltip + " " + TinkerUtil.getRomanNumeral(level);
        }
        if (detailed) {
            ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
            tooltip = tooltip + " " + data.extraInfo;
        }
        return tooltip;
    }

    public static class LuckAspect
    extends ModifierAspect.MultiAspect {
        public LuckAspect(IModifier parent) {
            super(parent, 5931746, 3, 60, 1);
            this.freeModifierAspect = new ModifierAspect.FreeFirstModifierAspect(parent, 1);
        }

        @Override
        protected int getMaxForLevel(int level) {
            return this.countPerLevel * level * (level + 1) / 2;
        }

        public int getLevel(int current) {
            int i = 0;
            while (current >= this.getMaxForLevel(i + 1)) {
                ++i;
            }
            return i;
        }
    }
}

