/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.ranged.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.crosshair.Crosshairs;
import slimeknights.tconstruct.library.client.crosshair.ICrosshair;
import slimeknights.tconstruct.library.client.crosshair.ICustomCrosshairUser;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ranged.BowCore;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;

public class ShortBow
extends BowCore
implements ICustomCrosshairUser {
    private ImmutableList<Item> arrowMatches = null;

    public ShortBow() {
        super(PartMaterialType.bowstring(TinkerTools.bowString), PartMaterialType.bow(TinkerTools.bowLimb), PartMaterialType.bow(TinkerTools.bowLimb));
    }

    @Override
    public void func_150895_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.addDefaultSubItems(subItems, TinkerMaterials.string);
    }

    @Override
    public float damagePotential() {
        return 0.7f;
    }

    @Override
    public double attackSpeed() {
        return 3.0;
    }

    @Override
    protected float baseInaccuracy() {
        return 1.0f;
    }

    @Override
    protected List<Item> getAmmoItems() {
        if (this.arrowMatches == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (TinkerRangedWeapons.arrow != null) {
                builder.add((Object)TinkerRangedWeapons.arrow);
            }
            builder.add((Object)Items.field_151032_g);
            builder.add((Object)Items.field_185167_i);
            builder.add((Object)Items.field_185166_h);
            this.arrowMatches = builder.build();
        }
        return this.arrowMatches;
    }

    @Override
    public ProjectileLauncherNBT buildTagData(List<Material> materials) {
        ProjectileLauncherNBT data = new ProjectileLauncherNBT();
        HeadMaterialStats head1 = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats head2 = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        BowMaterialStats limb1 = (BowMaterialStats)materials.get(1).getStatsOrUnknown("bow");
        BowMaterialStats limb2 = (BowMaterialStats)materials.get(2).getStatsOrUnknown("bow");
        BowStringMaterialStats bowstring = (BowStringMaterialStats)materials.get(0).getStatsOrUnknown("bowstring");
        data.head(head1, head2);
        data.limb(limb1, limb2);
        data.bowstring(bowstring);
        return data;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICrosshair getCrosshair(ItemStack itemStack, EntityPlayer player) {
        return Crosshairs.SQUARE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getCrosshairState(ItemStack itemStack, EntityPlayer player) {
        return this.getDrawbackProgress(itemStack, (EntityLivingBase)player);
    }
}

