/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.inventory.SlotWrapper;

public class ContainerMultiModule<T extends TileEntity>
extends BaseContainer<T> {
    public List<Container> subContainers = Lists.newArrayList();
    protected Map<Integer, Container> slotContainerMap = Maps.newHashMap();
    protected Map<Container, Pair<Integer, Integer>> subContainerSlotRanges = Maps.newHashMap();
    protected int subContainerSlotStart = -1;
    protected Set<Container> shiftClickContainers = Sets.newHashSet();

    public ContainerMultiModule(T tile) {
        super(tile);
    }

    public void addSubContainer(Container subcontainer, boolean preferForShiftClick) {
        if (this.subContainers.isEmpty()) {
            this.subContainerSlotStart = this.field_75151_b.size();
        }
        this.subContainers.add(subcontainer);
        if (preferForShiftClick) {
            this.shiftClickContainers.add(subcontainer);
        }
        int begin = this.field_75151_b.size();
        for (Object slot : subcontainer.field_75151_b) {
            SlotWrapper wrapper = new SlotWrapper((Slot)slot);
            this.func_75146_a(wrapper);
            this.slotContainerMap.put(wrapper.field_75222_d, subcontainer);
        }
        int end = this.field_75151_b.size();
        this.subContainerSlotRanges.put(subcontainer, (Pair<Integer, Integer>)Pair.of((Object)begin, (Object)end));
    }

    public <TC extends Container> TC getSubContainer(Class<TC> clazz) {
        return this.getSubContainer(clazz, 0);
    }

    public <TC extends Container> TC getSubContainer(Class<TC> clazz, int index) {
        for (Container sub : this.subContainers) {
            if (clazz.isAssignableFrom(sub.getClass())) {
                --index;
            }
            if (index >= 0) continue;
            return (TC)sub;
        }
        return null;
    }

    public Container getSlotContainer(int slotNumber) {
        if (this.slotContainerMap.containsKey(slotNumber)) {
            return this.slotContainerMap.get(slotNumber);
        }
        return this;
    }

    @Override
    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        for (Container sub : this.subContainers) {
            if (sub.func_75145_c(playerIn)) continue;
            return false;
        }
        return super.func_75145_c(playerIn);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        for (Container sub : this.subContainers) {
            sub.func_75134_a(playerIn);
        }
        super.func_75134_a(playerIn);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType type, EntityPlayer player) {
        if (slotId == -999 && type == ClickType.QUICK_CRAFT) {
            for (Container container : this.subContainers) {
                container.func_184996_a(slotId, dragType, type, player);
            }
        }
        return super.func_184996_a(slotId, dragType, type, player);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return null;
        }
        ItemStack ret = slot.func_75211_c().func_77946_l();
        ItemStack itemstack = slot.func_75211_c().func_77946_l();
        Container container = this.getSlotContainer(index);
        boolean nothingDone = true;
        if (container != this) {
            nothingDone &= this.moveToTileInventory(itemstack);
            nothingDone &= this.moveToPlayerInventory(itemstack);
        } else if (index < this.subContainerSlotStart || index < this.playerInventoryStart && this.subContainerSlotStart < 0) {
            nothingDone &= this.refillAnyContainer(itemstack, this.subContainers);
            nothingDone &= this.moveToPlayerInventory(itemstack);
            nothingDone &= this.moveToAnyContainer(itemstack, this.subContainers);
        } else if (index >= this.playerInventoryStart && this.playerInventoryStart >= 0) {
            nothingDone &= this.moveToTileInventory(itemstack);
            nothingDone &= this.moveToAnyContainer(itemstack, this.subContainers);
        } else {
            return null;
        }
        if (nothingDone) {
            return null;
        }
        return this.notifySlotAfterTransfer(playerIn, itemstack, ret, slot);
    }

    protected ItemStack notifySlotAfterTransfer(EntityPlayer player, ItemStack stack, ItemStack original, Slot slot) {
        slot.func_75220_a(stack, original);
        if (stack.field_77994_a == original.field_77994_a) {
            return null;
        }
        slot.func_75215_d(stack);
        slot.func_82870_a(player, stack);
        if (slot.func_75216_d() && slot.func_75211_c().field_77994_a == 0) {
            slot.func_75215_d(null);
        }
        return original;
    }

    protected boolean moveToTileInventory(ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a == 0) {
            return false;
        }
        int end = this.subContainerSlotStart;
        if (end < 0) {
            end = this.playerInventoryStart;
        }
        return !this.func_75135_a(itemstack, 0, end, false);
    }

    protected boolean moveToPlayerInventory(ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a == 0) {
            return false;
        }
        return this.playerInventoryStart > 0 && !this.func_75135_a(itemstack, this.playerInventoryStart, this.field_75151_b.size(), true);
    }

    protected boolean moveToAnyContainer(ItemStack itemstack, Collection<Container> containers) {
        if (itemstack == null || itemstack.field_77994_a == 0) {
            return false;
        }
        for (Container submodule : containers) {
            if (!this.moveToContainer(itemstack, submodule)) continue;
            return true;
        }
        return false;
    }

    protected boolean moveToContainer(ItemStack itemstack, Container container) {
        Pair<Integer, Integer> range = this.subContainerSlotRanges.get(container);
        return !this.func_75135_a(itemstack, (Integer)range.getLeft(), (Integer)range.getRight(), false);
    }

    protected boolean refillAnyContainer(ItemStack itemstack, Collection<Container> containers) {
        if (itemstack == null || itemstack.field_77994_a == 0) {
            return false;
        }
        for (Container submodule : containers) {
            if (!this.refillContainer(itemstack, submodule)) continue;
            return true;
        }
        return false;
    }

    protected boolean refillContainer(ItemStack itemstack, Container container) {
        Pair<Integer, Integer> range = this.subContainerSlotRanges.get(container);
        return !this.mergeItemStackRefill(itemstack, (Integer)range.getLeft(), (Integer)range.getRight(), false);
    }

    public <TE extends TileEntity> TE detectTE(Class<TE> clazz) {
        return (TE)((TileEntity)ObjectUtils.firstNonNull((Object[])new TileEntity[]{this.detectChest(this.pos.func_177978_c(), clazz), this.detectChest(this.pos.func_177974_f(), clazz), this.detectChest(this.pos.func_177968_d(), clazz), this.detectChest(this.pos.func_177976_e(), clazz)}));
    }

    private <TE extends TileEntity> TE detectChest(BlockPos pos, Class<TE> clazz) {
        TileEntity te = this.world.func_175625_s(pos);
        if (te != null && clazz.isAssignableFrom(te.getClass())) {
            return (TE)te;
        }
        return null;
    }
}

