/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.model;

import biomesoplenty.client.util.ModelUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;

public class ModelBiomeFinder
extends ItemOverrideList {
    private IBakedModel[] frames;

    public ModelBiomeFinder(IModel defaultModel, TextureAtlasSprite[] frameTextures) {
        super((List)ImmutableList.of());
        this.frames = ModelUtils.generateModelsForTextures(defaultModel, frameTextures);
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return this.frames[0];
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("biomeIDToFind")) {
            if (nbt.func_74764_b("searchStarted")) {
                return this.getFlashingFrame(player);
            }
            if (nbt.func_74767_n("found")) {
                int posX = nbt.func_74762_e("posX");
                int posZ = nbt.func_74762_e("posZ");
                return this.getFrameForPositionRelativeToPlayer((EntityPlayer)player, posX, posZ);
            }
            return this.frames[9];
        }
        return this.frames[8];
    }

    public IBakedModel getFlashingFrame(EntityPlayerSP player) {
        return player.func_70681_au().nextInt(2) == 0 ? this.frames[10] : this.frames[11];
    }

    public IBakedModel getFrameForPositionRelativeToPlayer(EntityPlayer player, int biomePosX, int biomePosZ) {
        double xDiff = (double)biomePosX - player.field_70165_t;
        double zDiff = (double)biomePosZ - player.field_70161_v;
        double angleDiff = Math.atan2(zDiff, xDiff) * 180.0 / Math.PI + 270.0 - (double)player.field_70177_z;
        int sector = (int)Math.floor((angleDiff + 22.5) / 45.0);
        return this.frames[(sector % 8 + 8) % 8];
    }
}

