/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.IBOPBlock;
import biomesoplenty.common.item.ItemBOPBlock;
import biomesoplenty.common.util.block.VariantPagingHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPFarmland
extends BlockFarmland
implements IBOPBlock {
    public static VariantPagingHelper<BlockBOPFarmland, BlockBOPDirt.BOPDirtType> paging = new VariantPagingHelper(2, BlockBOPDirt.BOPDirtType.class);
    private static IProperty currentVariantProperty;
    public IProperty variantProperty;

    public static void createAllPages() {
        int numPages = paging.getNumPages();
        for (int i = 0; i < numPages; ++i) {
            currentVariantProperty = paging.getVariantProperty(i);
            paging.addBlock(i, new BlockBOPFarmland());
        }
    }

    protected BlockStateContainer func_180661_e() {
        this.variantProperty = currentVariantProperty;
        return new BlockStateContainer((Block)this, new IProperty[]{field_176531_a, this.variantProperty});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{this.variantProperty};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((BlockBOPDirt.BOPDirtType)((Object)state.func_177229_b(this.variantProperty))).func_176610_l() + "_farmland";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return null;
    }

    public BlockBOPFarmland() {
        this.func_149675_a(true);
        this.func_149713_g(255);
        this.field_149783_u = true;
        this.func_149711_c(0.6f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(0)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.variantProperty, (Comparable)((Object)paging.getVariant(this, meta & 1))).func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(meta >> 1));
    }

    public int func_176201_c(IBlockState state) {
        BlockBOPDirt.BOPDirtType dirt = (BlockBOPDirt.BOPDirtType)((Object)state.func_177229_b(this.variantProperty));
        int meta = paging.getIndex(dirt);
        return meta |= (Integer)state.func_177229_b((IProperty)field_176531_a) << 1;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        int i = (Integer)state.func_177229_b((IProperty)field_176531_a);
        if (!this.hasWater(world, pos) && !world.func_175727_C(pos.func_177984_a())) {
            if (i > 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops(world, pos)) {
                world.func_175656_a(pos, this.getDirtBlockState(world.func_180495_p(pos)));
            }
        } else if (i < 7) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    private boolean hasWater(World world, BlockPos pos) {
        for (BlockPos.MutableBlockPos mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (world.func_180495_p((BlockPos)mutableblockpos).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    private boolean hasCrops(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)block);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            world.func_175656_a(pos, this.getDirtBlockState(world.func_180495_p(pos)));
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (entity instanceof EntityLivingBase && !world.field_72995_K && world.field_73012_v.nextFloat() < fallDistance - 0.5f) {
            if (!(entity instanceof EntityPlayer) && !world.func_82736_K().func_82766_b("mobGriefing")) {
                return;
            }
            world.func_175656_a(pos, this.getDirtBlockState(world.func_180495_p(pos)));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BOPBlocks.dirt);
    }

    public int func_180651_a(IBlockState state) {
        return BOPBlocks.dirt.func_176201_c(this.getDirtBlockState(state));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(BOPBlocks.dirt, 1, BOPBlocks.dirt.func_176201_c(this.getDirtBlockState(world.func_180495_p(pos))));
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177984_a());
        switch (plantType) {
            case Crop: {
                return true;
            }
            case Plains: {
                return true;
            }
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public IBlockState getDirtBlockState(IBlockState state) {
        switch ((BlockBOPDirt.BOPDirtType)((Object)state.func_177229_b(this.variantProperty))) {
            case LOAMY: {
                return BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.LOAMY));
            }
            case SANDY: {
                return BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SANDY));
            }
            case SILTY: {
                return BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SILTY));
            }
        }
        return Blocks.field_150346_d.func_176203_a(BlockDirt.DirtType.DIRT.func_176925_a());
    }
}

