/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.handler.decoration;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.api.generation.IGenerationManager;
import biomesoplenty.api.generation.IGenerator;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DecorateBiomeEventHandler {
    @SubscribeEvent
    public void onPreBiomeDecorate(DecorateBiomeEvent.Pre event) {
        if (BOPBiomes.excludedDecoratedWorldTypes.contains(event.getWorld().func_175624_G())) {
            return;
        }
        DecorateBiomeEventHandler.runGeneratorStage(event.getWorld(), event.getRand(), event.getPos(), GeneratorStage.PRE);
    }

    @SubscribeEvent
    public void onBiomeDecorate(DecorateBiomeEvent.Decorate event) {
        if (BOPBiomes.excludedDecoratedWorldTypes.contains(event.getWorld().func_175624_G())) {
            return;
        }
        if (event.getType() != DecorateBiomeEvent.Decorate.EventType.CUSTOM) {
            boolean allow = DecorateBiomeEventHandler.runGeneratorStage(event.getWorld(), event.getRand(), event.getPos(), GeneratorStage.mapDecorateType(event.getType()));
            event.setResult(allow ? Event.Result.ALLOW : Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPostBiomeDecorate(DecorateBiomeEvent.Post event) {
        if (BOPBiomes.excludedDecoratedWorldTypes.contains(event.getWorld().func_175624_G())) {
            return;
        }
        DecorateBiomeEventHandler.runGeneratorStage(event.getWorld(), event.getRand(), event.getPos(), GeneratorStage.POST);
    }

    @SubscribeEvent
    public void onPreGenerateOres(OreGenEvent.Pre event) {
        if (BOPBiomes.excludedDecoratedWorldTypes.contains(event.getWorld().func_175624_G())) {
            return;
        }
        DecorateBiomeEventHandler.runGeneratorStage(event.getWorld(), event.getRand(), event.getPos(), GeneratorStage.ORE_PRE);
    }

    @SubscribeEvent
    public void onPostGenerateOres(OreGenEvent.Post event) {
        if (BOPBiomes.excludedDecoratedWorldTypes.contains(event.getWorld().func_175624_G())) {
            return;
        }
        DecorateBiomeEventHandler.runGeneratorStage(event.getWorld(), event.getRand(), event.getPos(), GeneratorStage.ORE_POST);
    }

    private static boolean runGeneratorStage(World world, Random random, BlockPos pos, GeneratorStage stage) {
        Biome biome = world.func_180494_b(pos.func_177982_a(16, 0, 16));
        IExtendedBiome extendedBiome = BOPBiomes.REG_INSTANCE.getExtendedBiome(biome);
        if (extendedBiome != null) {
            IGenerationManager generationManager = extendedBiome.getGenerationManager();
            for (IGenerator generator : generationManager.getGeneratorsForStage(stage)) {
                generator.scatter(world, random, pos);
            }
        }
        return true;
    }
}

