/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.generation.BOPGenLayer;
import biomesoplenty.common.util.biome.BiomeUtils;
import com.google.common.base.Predicate;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.biome.BiomeMesa;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerShoreBOP
extends BOPGenLayer {
    private static final Predicate<Integer> OCEAN_PREDICATE = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return input == Biome.func_185362_a((Biome)Biomes.field_76771_b);
        }
    };
    private static final Predicate<Integer> OCEANIC_PREDICATE = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return GenLayerShoreBOP.func_151618_b((int)input);
        }
    };
    private static final Predicate<Integer> JUNGLE_BORDER_PREDICATE = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return Biome.func_150568_d((int)input) != null && Biome.func_150568_d((int)input).func_150562_l() == BiomeJungle.class ? true : input == Biome.func_185362_a((Biome)Biomes.field_150574_L) || input == Biome.func_185362_a((Biome)Biomes.field_76782_w) || input == Biome.func_185362_a((Biome)Biomes.field_76792_x) || input == Biome.func_185362_a((Biome)Biomes.field_76767_f) || input == Biome.func_185362_a((Biome)Biomes.field_76768_g) || GenLayerShoreBOP.func_151618_b((int)input);
        }
    };
    private static final Predicate<Integer> MESA_PREDICATE = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return !(Biome.func_150568_d((int)input) instanceof BiomeMesa);
        }
    };

    public GenLayerShoreBOP(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] biomeIds = this.field_75909_a.func_75904_a(areaX - 1, areaY - 1, areaWidth + 2, areaHeight + 2);
        int[] out = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int z = 0; z < areaHeight; ++z) {
            for (int x = 0; x < areaWidth; ++x) {
                int biomeSouth;
                int biomeWest;
                int biomeEast;
                int biomeNorth;
                this.func_75903_a(x + areaX, z + areaY);
                int biomeId = biomeIds[x + 1 + (z + 1) * (areaWidth + 2)];
                Biome biome = Biome.func_150568_d((int)biomeId);
                if (biomeId == Biome.func_185362_a((Biome)Biomes.field_76789_p)) {
                    this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, Biome.func_185362_a((Biome)Biomes.field_76788_q), OCEAN_PREDICATE);
                    continue;
                }
                if (biome != null && biome.func_150562_l() == BiomeJungle.class) {
                    biomeNorth = biomeIds[x + 1 + (z + 1 - 1) * (areaWidth + 2)];
                    biomeEast = biomeIds[x + 1 + 1 + (z + 1) * (areaWidth + 2)];
                    biomeWest = biomeIds[x + 1 - 1 + (z + 1) * (areaWidth + 2)];
                    biomeSouth = biomeIds[x + 1 + (z + 1 + 1) * (areaWidth + 2)];
                    if (JUNGLE_BORDER_PREDICATE.apply((Object)biomeNorth) && JUNGLE_BORDER_PREDICATE.apply((Object)biomeEast) && JUNGLE_BORDER_PREDICATE.apply((Object)biomeWest) && JUNGLE_BORDER_PREDICATE.apply((Object)biomeSouth)) {
                        this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, Biome.func_185362_a((Biome)Biomes.field_76787_r), OCEANIC_PREDICATE);
                        continue;
                    }
                    out[x + z * areaWidth] = Biome.func_185362_a((Biome)Biomes.field_150574_L);
                    continue;
                }
                if (biomeId != Biome.func_185362_a((Biome)Biomes.field_76770_e) && biomeId != Biome.func_185362_a((Biome)Biomes.field_150580_W) && biomeId != Biome.func_185362_a((Biome)Biomes.field_76783_v)) {
                    if (biome != null && biome.func_150559_j()) {
                        if (GenLayerShoreBOP.func_151618_b((int)biomeId)) {
                            out[x + z * areaWidth] = biomeId;
                            continue;
                        }
                        this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, Biome.func_185362_a((Biome)Biomes.field_150577_O), OCEANIC_PREDICATE);
                        continue;
                    }
                    if (biomeId != Biome.func_185362_a((Biome)Biomes.field_150589_Z) && biomeId != Biome.func_185362_a((Biome)Biomes.field_150607_aa)) {
                        if (biomeId != Biome.func_185362_a((Biome)Biomes.field_76771_b) && biomeId != Biome.func_185362_a((Biome)Biomes.field_150575_M) && biomeId != Biome.func_185362_a((Biome)Biomes.field_76781_i) && biomeId != Biome.func_185362_a((Biome)Biomes.field_76780_h)) {
                            if (biome != null && BOPBiomes.REG_INSTANCE.getExtendedBiome(biome) != null) {
                                IExtendedBiome extBiome = BOPBiomes.REG_INSTANCE.getExtendedBiome(biome);
                                Biome beachBiome = BiomeUtils.getBiomeForLoc(extBiome.getBeachLocation());
                                this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, beachBiome == null ? biomeId : Biome.func_185362_a((Biome)beachBiome), OCEANIC_PREDICATE);
                                continue;
                            }
                            this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, Biome.func_185362_a((Biome)Biomes.field_76787_r), OCEANIC_PREDICATE);
                            continue;
                        }
                        out[x + z * areaWidth] = biomeId;
                        continue;
                    }
                    biomeNorth = biomeIds[x + 1 + (z + 1 - 1) * (areaWidth + 2)];
                    biomeEast = biomeIds[x + 1 + 1 + (z + 1) * (areaWidth + 2)];
                    biomeWest = biomeIds[x + 1 - 1 + (z + 1) * (areaWidth + 2)];
                    biomeSouth = biomeIds[x + 1 + (z + 1 + 1) * (areaWidth + 2)];
                    if (!(GenLayerShoreBOP.func_151618_b((int)biomeNorth) || GenLayerShoreBOP.func_151618_b((int)biomeEast) || GenLayerShoreBOP.func_151618_b((int)biomeWest) || GenLayerShoreBOP.func_151618_b((int)biomeSouth))) {
                        this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, Biome.func_185362_a((Biome)Biomes.field_76769_d), MESA_PREDICATE);
                        continue;
                    }
                    out[x + z * areaWidth] = biomeId;
                    continue;
                }
                this.setBiomeWithAdjacent(biomeIds, out, x, z, areaWidth, biomeId, Biome.func_185362_a((Biome)Biomes.field_150576_N), OCEANIC_PREDICATE);
            }
        }
        return out;
    }

    private void setBiomeWithAdjacent(int[] biomeIds, int[] out, int x, int z, int areaWidth, int biomeId, int beachId, Predicate<Integer> adjacentPredicate) {
        int biomeNorth = biomeIds[x + 1 + (z + 1 - 1) * (areaWidth + 2)];
        int biomeEast = biomeIds[x + 1 + 1 + (z + 1) * (areaWidth + 2)];
        int biomeWest = biomeIds[x + 1 - 1 + (z + 1) * (areaWidth + 2)];
        int biomeSouth = biomeIds[x + 1 + (z + 1 + 1) * (areaWidth + 2)];
        out[x + z * areaWidth] = adjacentPredicate.apply((Object)biomeNorth) || adjacentPredicate.apply((Object)biomeEast) || adjacentPredicate.apply((Object)biomeWest) || adjacentPredicate.apply((Object)biomeSouth) ? beachId : biomeId;
    }
}

