/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution;

import com.brandon3055.brandonscore.config.ModConfigProcessor;
import com.brandon3055.brandonscore.config.ModFeatureParser;
import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.draconicevolution.CommonProxy;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.GuiHandler;
import com.brandon3055.draconicevolution.OreHandler;
import com.brandon3055.draconicevolution.client.creativetab.DETab;
import com.brandon3055.draconicevolution.command.CommandUpgrade;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.brandon3055.draconicevolution.world.DEWorldGenHandler;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

@Mod(modid="draconicevolution", name="Draconic Evolution", version="2.0.1", canBeDeactivated=false, guiFactory="", dependencies="after:NotEnoughItems;after:ThermalExpansion;after:ThermalFoundation;required-after:brandonscore@[2.1.0,);", acceptedMinecraftVersions="[1.10.2]")
public class DraconicEvolution {
    public static final String MODID = "draconicevolution";
    public static final String MODNAME = "Draconic Evolution";
    public static final String VERSION = "2.0.1";
    public static final String MOD_PREFIX = "draconicevolution".toLowerCase() + ":";
    public static final String PROXY_CLIENT = "com.brandon3055.draconicevolution.client.ClientProxy";
    public static final String PROXY_SERVER = "com.brandon3055.draconicevolution.CommonProxy";
    public static final String DEPENDENCIES = "after:NotEnoughItems;after:ThermalExpansion;after:ThermalFoundation;required-after:brandonscore@[2.1.0,);";
    public static final String GUI_FACTORY = "";
    public static final String networkChannelName = "DEvolutionNC";
    public static CreativeTabs tabToolsWeapons = new DETab(CreativeTabs.getNextID(), "draconicevolution", "toolsAndWeapons", 0);
    public static CreativeTabs tabBlocksItems = new DETab(CreativeTabs.getNextID(), "draconicevolution", "blocksAndItems", 1);
    public static SimpleNetworkWrapper network;
    public static boolean debug;
    public static Configuration configuration;
    @Mod.Instance(value="draconicevolution")
    public static DraconicEvolution instance;
    @SidedProxy(clientSide="com.brandon3055.draconicevolution.client.ClientProxy", serverSide="com.brandon3055.draconicevolution.CommonProxy")
    public static CommonProxy proxy;
    public static ModFeatureParser featureParser;
    public static ModConfigProcessor configProcessor;

    public DraconicEvolution() {
        LogHelper.info("Hello Minecraft!!!");
        LogHelper.info("Starting Draconic Evolution non-Beta! Deactivating Random Bug Generator!!!");
        LogHelper.warn("=======================================================");
        LogHelper.warn("+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+");
        LogHelper.warn("If the game crashes on first start after automatically");
        LogHelper.warn("installing CCL just try restarting.");
        LogHelper.warn("There is currently a minor bug in the CCL downloader.");
        LogHelper.warn("+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+");
        LogHelper.warn("=======================================================");
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandUpgrade());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configuration = new Configuration(new File(FileHandler.brandon3055Folder, "DraconicEvolution.cfg"));
        configProcessor.initialize(configuration, DEConfig.comments, new Class[]{DEConfig.class, ToolStats.class});
        configProcessor.loadConfig();
        featureParser.loadFeatures(DEFeatures.class);
        featureParser.loadFeatureConfig(configuration);
        featureParser.registerFeatures();
        OreHandler.initialize();
        proxy.preInit(event);
        proxy.registerParticles();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        DEWorldGenHandler.initialize();
        GuiHandler.initialize();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void processMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            LogHelper.info(m.key);
            if (!m.isItemStackMessage() || !m.key.contains("addChestRecipe:")) continue;
            String s = m.key.substring(m.key.indexOf("addChestRecipe:") + 15);
            LogHelper.info("Added Chest recipe override: " + s + " to " + m.getItemStackValue());
        }
    }

    static {
        debug = false;
        featureParser = new ModFeatureParser(MODID, new CreativeTabs[]{tabBlocksItems, tabToolsWeapons});
        configProcessor = new ModConfigProcessor();
    }
}

