/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.fusioncrafting;

import com.brandon3055.draconicevolution.api.OreDictHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.ICraftingPedestal;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SimpleFusionRecipe
implements IFusionRecipe {
    protected ItemStack result;
    protected ItemStack catalyst;
    protected List<Object> ingredients;
    protected int energyCost;
    protected int craftingTier;

    public SimpleFusionRecipe(ItemStack result, ItemStack catalyst, int energyCost, int craftingTier, Object ... ingredients) {
        this.result = result;
        this.catalyst = catalyst;
        this.ingredients = new LinkedList<Object>();
        Collections.addAll(this.ingredients, ingredients);
        this.energyCost = energyCost;
        this.craftingTier = craftingTier;
    }

    @Override
    public ItemStack getRecipeOutput(@Nullable ItemStack catalyst) {
        return this.result;
    }

    @Override
    public boolean isRecipeCatalyst(ItemStack catalyst) {
        return catalyst != null && this.catalyst.func_77969_a(catalyst);
    }

    @Override
    public ItemStack getRecipeCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getRecipeTier() {
        return this.craftingTier;
    }

    @Override
    public List<Object> getRecipeIngredients() {
        return this.ingredients;
    }

    @Override
    public boolean matches(IFusionCraftingInventory inventory, World world, BlockPos pos) {
        ArrayList<ICraftingPedestal> pedestals = new ArrayList<ICraftingPedestal>();
        pedestals.addAll(inventory.getPedestals());
        if (inventory.getStackInCore(0) == null || !inventory.getStackInCore(0).func_77969_a(this.catalyst) || inventory.getStackInCore((int)0).field_77994_a < this.catalyst.field_77994_a) {
            return false;
        }
        for (Object ingredient : this.ingredients) {
            boolean foundIngredient = false;
            for (ICraftingPedestal pedestal : pedestals) {
                if (pedestal.getStackInPedestal() == null || !OreDictHelper.areStacksEqual(ingredient, pedestal.getStackInPedestal())) continue;
                foundIngredient = true;
                pedestals.remove(pedestal);
                break;
            }
            if (foundIngredient) continue;
            return false;
        }
        for (ICraftingPedestal pedestal : pedestals) {
            if (pedestal.getStackInPedestal() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void craft(IFusionCraftingInventory inventory, World world, BlockPos pos) {
        if (!this.matches(inventory, world, pos)) {
            return;
        }
        ArrayList<ICraftingPedestal> pedestals = new ArrayList<ICraftingPedestal>();
        pedestals.addAll(inventory.getPedestals());
        block0: for (Object ingredient : this.ingredients) {
            for (ICraftingPedestal pedestal : pedestals) {
                if (pedestal.getStackInPedestal() == null || !OreDictHelper.areStacksEqual(ingredient, pedestal.getStackInPedestal()) || pedestal.getPedestalTier() < this.craftingTier) continue;
                ItemStack stack = pedestal.getStackInPedestal();
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    stack = stack.func_77973_b().getContainerItem(stack);
                } else {
                    --stack.field_77994_a;
                    if (stack.field_77994_a <= 0) {
                        stack = null;
                    }
                }
                pedestal.setStackInPedestal(stack);
                pedestals.remove(pedestal);
                continue block0;
            }
        }
        ItemStack catalyst = inventory.getStackInCore(0);
        catalyst.field_77994_a -= this.catalyst.field_77994_a;
        if (catalyst.field_77994_a <= 0) {
            catalyst = null;
        }
        inventory.setStackInCore(0, catalyst);
        inventory.setStackInCore(1, this.result.func_77946_l());
    }

    @Override
    public int getEnergyCost() {
        return this.energyCost;
    }

    @Override
    public void onCraftingTick(IFusionCraftingInventory inventory, World world, BlockPos pos) {
    }

    @Override
    public String canCraft(IFusionCraftingInventory inventory, World world, BlockPos pos) {
        if (inventory.getStackInCore(1) != null) {
            return "outputObstructed";
        }
        ArrayList<ICraftingPedestal> pedestals = new ArrayList<ICraftingPedestal>();
        pedestals.addAll(inventory.getPedestals());
        for (ICraftingPedestal pedestal : pedestals) {
            if (pedestal.getStackInPedestal() == null || pedestal.getPedestalTier() >= this.craftingTier) continue;
            return "tierLow";
        }
        return "true";
    }

    public String toString() {
        return String.format("SimpleFusionRecipe: {Result: %s, Catalyst: %s}", this.result, this.catalyst);
    }
}

