/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemupgrade;

import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.OreDictHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.ICraftingPedestal;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FusionUpgradeRecipe
implements IFusionRecipe {
    protected final int upgradeLevel;
    protected final ItemStack upgradeKey;
    protected final String upgrade;
    protected List<Object> ingredients;
    protected int energyCost;
    protected int craftingTier;
    private static Item[] tools = new Item[]{DEFeatures.wyvernAxe, DEFeatures.draconicAxe, DEFeatures.wyvernShovel, DEFeatures.draconicShovel, DEFeatures.wyvernPick, DEFeatures.draconicPick, DEFeatures.wyvernSword, DEFeatures.draconicSword, DEFeatures.wyvernBow, DEFeatures.draconicBow, DEFeatures.draconicStaffOfPower};
    private static Random rand = new Random();

    public FusionUpgradeRecipe(String upgrade, ItemStack upgradeKey, int energyCost, int craftingTier, int upgradeLevel, Object ... ingredients) {
        this.upgrade = upgrade;
        this.upgradeLevel = upgradeLevel;
        this.upgradeKey = upgradeKey;
        this.ingredients = new LinkedList<Object>();
        Collections.addAll(this.ingredients, ingredients);
        this.ingredients.add(upgradeKey);
        this.energyCost = energyCost;
        this.craftingTier = craftingTier;
    }

    @Override
    public ItemStack getRecipeOutput(@Nullable ItemStack catalyst) {
        if (catalyst == null) {
            return null;
        }
        ItemStack stack = catalyst.func_77946_l();
        UpgradeHelper.setUpgradeLevel(stack, this.upgrade, this.upgradeLevel);
        return stack;
    }

    @Override
    public boolean isRecipeCatalyst(ItemStack catalyst) {
        return catalyst != null && catalyst.func_77973_b() instanceof IUpgradableItem && ((IUpgradableItem)catalyst.func_77973_b()).getValidUpgrades(catalyst).contains(this.upgrade);
    }

    @Override
    public ItemStack getRecipeCatalyst() {
        return new ItemStack(tools[rand.nextInt(tools.length)]);
    }

    @Override
    public int getRecipeTier() {
        return this.craftingTier;
    }

    @Override
    public List<Object> getRecipeIngredients() {
        return this.ingredients;
    }

    @Override
    public boolean matches(IFusionCraftingInventory inventory, World world, BlockPos pos) {
        ArrayList<ICraftingPedestal> pedestals = new ArrayList<ICraftingPedestal>();
        pedestals.addAll(inventory.getPedestals());
        if (!this.isRecipeCatalyst(inventory.getStackInCore(0))) {
            return false;
        }
        boolean flag = false;
        for (ICraftingPedestal pedestal : pedestals) {
            if (pedestal.getStackInPedestal() == null || !this.upgradeKey.func_77969_a(pedestal.getStackInPedestal())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        for (Object ingredient : this.ingredients) {
            flag = false;
            for (ICraftingPedestal pedestal : pedestals) {
                if (pedestal.getStackInPedestal() == null || !OreDictHelper.areStacksEqual(ingredient, pedestal.getStackInPedestal())) continue;
                flag = true;
                pedestals.remove(pedestal);
                break;
            }
            if (flag) continue;
            return false;
        }
        for (ICraftingPedestal pedestal : pedestals) {
            if (pedestal.getStackInPedestal() == null || pedestal.getStackInPedestal().func_77969_a(this.upgradeKey)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String canCraft(IFusionCraftingInventory inventory, World world, BlockPos pos) {
        if (!this.isRecipeCatalyst(inventory.getStackInCore(0))) {
            return "upgrade.de.upgradeNA.info";
        }
        if (inventory.getStackInCore(1) != null) {
            return "outputObstructed";
        }
        IUpgradableItem item = (IUpgradableItem)inventory.getStackInCore(0).func_77973_b();
        if (item.getMaxUpgradeLevel(inventory.getStackInCore(0), this.upgrade) < this.upgradeLevel) {
            return "upgrade.de.upgradeLevelToHigh.info";
        }
        if (UpgradeHelper.getUpgradeLevel(inventory.getStackInCore(0), this.upgrade) >= this.upgradeLevel) {
            return "upgrade.de.upgradeApplied.info";
        }
        if (UpgradeHelper.getUpgradeLevel(inventory.getStackInCore(0), this.upgrade) < this.upgradeLevel - 1) {
            return "upgrade.de.upgradePrevLevelRequired.info";
        }
        ArrayList<ICraftingPedestal> pedestals = new ArrayList<ICraftingPedestal>();
        pedestals.addAll(inventory.getPedestals());
        for (ICraftingPedestal pedestal : pedestals) {
            if (pedestal.getStackInPedestal() == null || pedestal.getPedestalTier() >= this.craftingTier) continue;
            return "tierLow";
        }
        return "true";
    }

    @Override
    public void craft(IFusionCraftingInventory inventory, World world, BlockPos pos) {
        if (!this.matches(inventory, world, pos)) {
            return;
        }
        ArrayList<ICraftingPedestal> pedestals = new ArrayList<ICraftingPedestal>();
        pedestals.addAll(inventory.getPedestals());
        block0: for (Object ingredient : this.ingredients) {
            for (ICraftingPedestal pedestal : pedestals) {
                if (pedestal.getStackInPedestal() == null || !OreDictHelper.areStacksEqual(ingredient, pedestal.getStackInPedestal()) || pedestal.getPedestalTier() < this.craftingTier || pedestal.getStackInPedestal().func_77969_a(this.upgradeKey)) continue;
                ItemStack stack = pedestal.getStackInPedestal();
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    stack = stack.func_77973_b().getContainerItem(stack);
                } else {
                    --stack.field_77994_a;
                    if (stack.field_77994_a <= 0) {
                        stack = null;
                    }
                }
                pedestal.setStackInPedestal(stack);
                pedestals.remove(pedestal);
                continue block0;
            }
        }
        ItemStack stack = inventory.getStackInCore(0);
        inventory.setStackInCore(0, null);
        UpgradeHelper.setUpgradeLevel(stack, this.upgrade, this.upgradeLevel);
        inventory.setStackInCore(1, stack);
    }

    @Override
    public int getEnergyCost() {
        return this.energyCost;
    }

    @Override
    public void onCraftingTick(IFusionCraftingInventory inventory, World world, BlockPos pos) {
    }

    public String toString() {
        return String.format("FusionUpgradeRecipe: [Upgrade: %s, Level: %s]", this.upgrade, this.upgradeLevel);
    }
}

