/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.config.ModFeatureParser;
import com.brandon3055.draconicevolution.DEFeatures;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DraconiumOre
extends BlockBCore {
    public static PropertyEnum<EnumType> ORE_TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    public DraconiumOre() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 3);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ORE_TYPE, (Comparable)((Object)EnumType.NORMAL)));
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (EnumType enumType : EnumType.values()) {
            list.add(new ItemStack(item, 1, enumType.getMeta()));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ORE_TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(ORE_TYPE))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ORE_TYPE, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a(ORE_TYPE, (Comparable)((Object)EnumType.byMetadata(stack.func_77952_i()))));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((EnumType)((Object)world.func_180495_p(pos).func_177229_b(ORE_TYPE))).getMeta());
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return DEFeatures.draconiumDust;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 4 - ((EnumType)((Object)state.func_177229_b(ORE_TYPE))).getMeta() + random.nextInt(2 + fortune * 2);
    }

    public static IBlockState getEnd() {
        if (ModFeatureParser.isEnabled((Object)((Object)DEFeatures.draconiumOre))) {
            return DEFeatures.draconiumOre.func_176223_P().func_177226_a(ORE_TYPE, (Comparable)((Object)EnumType.END));
        }
        return Blocks.field_150377_bs.func_176223_P();
    }

    public static IBlockState getNether() {
        if (ModFeatureParser.isEnabled((Object)((Object)DEFeatures.draconiumOre))) {
            return DEFeatures.draconiumOre.func_176223_P().func_177226_a(ORE_TYPE, (Comparable)((Object)EnumType.NETHER));
        }
        return Blocks.field_150424_aL.func_176223_P();
    }

    public static enum EnumType implements IStringSerializable
    {
        NORMAL(0, "normal"),
        NETHER(1, "nether"),
        END(2, "end");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] arr$ = EnumType.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMeta()] = type = arr$[i$];
            }
        }
    }
}

