/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.api.IDataRetainerTile;
import com.brandon3055.brandonscore.api.IMultiBlock;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.network.PacketTileMessage;
import com.brandon3055.brandonscore.network.wrappers.SyncableBool;
import com.brandon3055.brandonscore.network.wrappers.SyncableByte;
import com.brandon3055.brandonscore.network.wrappers.SyncableLong;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableVec3I;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.IExtendedRFStorage;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.brandon3055.draconicevolution.world.EnergyCoreStructure;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEnergyStorageCore
extends TileBCBase
implements IDataRetainerTile,
ITickable,
IExtendedRFStorage,
IMultiBlock {
    public static final byte ORIENT_UNKNOWN = 0;
    public static final byte ORIENT_UP_DOWN = 1;
    public static final byte ORIENT_NORTH_SOUTH = 2;
    public static final byte ORIENT_EAST_WEST = 3;
    public static final EnumFacing[][] STAB_ORIENTATIONS = new EnumFacing[][]{new EnumFacing[0], EnumFacing.field_176754_o, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}};
    public static final long[] CAPACITY = new long[]{45500000L, 273000000L, 1640000000L, 9880000000L, 59300000000L, 356000000000L, 2140000000000L, Long.MAX_VALUE};
    public final EnergyCoreStructure coreStructure = new EnergyCoreStructure().initialize(this);
    public final SyncableBool active = new SyncableBool(false, true, false, true);
    public final SyncableBool structureValid = new SyncableBool(false, true, false, true);
    public final SyncableBool coreValid = new SyncableBool(false, true, false, true);
    public final SyncableBool buildGuide = new SyncableBool(false, true, false, true);
    public final SyncableBool stabilizersOK = new SyncableBool(false, false, true, true);
    public final SyncableByte tier = new SyncableByte(1, true, false, true);
    public final SyncableLong energy = new SyncableLong(0L, true, false, false);
    public final SyncableVec3I[] stabOffsets = new SyncableVec3I[4];
    public final SyncableLong transferRate = new SyncableLong(0L, false, true, false);
    private int ticksElapsed = 0;
    private long[] flowArray = new long[20];
    public float rotation = 0.0f;

    public TileEnergyStorageCore() {
        this.setShouldRefreshOnBlockChange();
        this.registerSyncableObject((SyncableObject)this.active, true);
        this.registerSyncableObject((SyncableObject)this.structureValid, true);
        this.registerSyncableObject((SyncableObject)this.coreValid, true);
        this.registerSyncableObject((SyncableObject)this.buildGuide, true);
        this.registerSyncableObject((SyncableObject)this.stabilizersOK, true);
        this.registerSyncableObject((SyncableObject)this.tier, true);
        this.registerSyncableObject((SyncableObject)this.energy, true);
        this.registerSyncableObject((SyncableObject)this.transferRate, false);
        for (int i = 0; i < this.stabOffsets.length; ++i) {
            this.stabOffsets[i] = new SyncableVec3I(new Vec3I(0, -1, 0), true, false, false);
            this.registerSyncableObject((SyncableObject)this.stabOffsets[i], true);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.flowArray[this.ticksElapsed % 20] = this.energy.value - this.energy.lastTickValue;
            long total = 0L;
            for (long i : this.flowArray) {
                total += i;
            }
            this.transferRate.value = total / 20L;
        } else {
            this.rotation += 1.0f;
        }
        this.detectAndSendChanges();
        if (this.ticksElapsed % 20 == 0 && !this.field_145850_b.field_72995_K) {
            this.transferRate.detectAndSendChanges((TileBCBase)this, null, false);
        }
        if (this.field_145850_b.field_72995_K && this.active.value) {
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b(10.0, 10.0, 10.0));
            for (EntityPlayer player : players) {
                double dist = player.func_70011_f((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 0.4, (double)this.field_174879_c.func_177952_p() + 0.5);
                double distNext = player.func_70011_f((double)this.field_174879_c.func_177958_n() + player.field_70159_w + 0.5, (double)this.field_174879_c.func_177956_o() + player.field_70181_x - 0.4, (double)this.field_174879_c.func_177952_p() + player.field_70179_y + 0.5);
                double threshold = this.tier.value > 2 ? (double)this.tier.value - 0.5 : (double)this.tier.value + 0.5;
                double boundary = distNext - threshold;
                double dir = dist - distNext;
                if (!(boundary <= 0.0)) continue;
                if (dir < 0.0) {
                    player.func_70091_d(-player.field_70159_w * 1.5, -player.field_70181_x * 1.5, -player.field_70179_y * 1.5);
                }
                double multiplier = (threshold - dist) * 0.05;
                double xm = ((double)this.field_174879_c.func_177958_n() + 0.5 - player.field_70165_t) / distNext * multiplier;
                double ym = ((double)this.field_174879_c.func_177956_o() - 0.4 - player.field_70163_u) / distNext * multiplier;
                double zm = ((double)this.field_174879_c.func_177952_p() + 0.5 - player.field_70161_v) / distNext * multiplier;
                player.func_70091_d(-xm, -ym, -zm);
            }
        }
        ++this.ticksElapsed;
    }

    public void onStructureClicked(World world, BlockPos blockClicked, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.validateStructure();
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)DraconicEvolution.instance, (int)16, (World)world, (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p());
        }
    }

    public void activateCore() {
        if (this.field_145850_b.field_72995_K || !this.validateStructure()) {
            return;
        }
        if (this.energy.value > this.getCapacity()) {
            this.energy.value = this.getCapacity();
        }
        this.buildGuide.value = false;
        this.coreStructure.formTier(this.tier.value);
        this.active.value = true;
        this.updateStabilizers(true);
    }

    public void deactivateCore() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.coreStructure.revertTier(this.tier.value);
        this.active.value = false;
        this.updateStabilizers(false);
    }

    private long getCapacity() {
        if (this.tier.value <= 0 || this.tier.value > 8) {
            LogHelper.error("Tier not valid! WTF!!!");
            return 0L;
        }
        return CAPACITY[this.tier.value - 1];
    }

    public void receivePacketFromClient(PacketTileMessage packet, EntityPlayerMP client) {
        if (packet.getIndex() == 0) {
            if (this.active.value) {
                this.deactivateCore();
            } else {
                this.activateCore();
            }
        } else if (packet.getIndex() == 1) {
            if (!this.active.value && this.tier.value < 8) {
                this.tier.value = (byte)(this.tier.value + 1);
                this.validateStructure();
            }
        } else if (packet.getIndex() == 2) {
            if (!this.active.value && this.tier.value > 1) {
                this.tier.value = (byte)(this.tier.value - 1);
                this.validateStructure();
            }
        } else if (packet.getIndex() == 3) {
            if (!this.active.value) {
                this.buildGuide.value = !this.buildGuide.value;
            }
        } else if (packet.getIndex() == 4 && !this.active.value && client.field_71075_bZ.field_75098_d) {
            this.coreStructure.placeTier(this.tier.value);
            this.validateStructure();
        }
    }

    private void updateStabilizers(boolean coreActive) {
        for (SyncableVec3I offset : this.stabOffsets) {
            BlockPos tilePos = this.field_174879_c.func_177982_a(-offset.vec.x, -offset.vec.y, -offset.vec.z);
            TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
            if (!(tile instanceof TileEnergyCoreStabilizer)) continue;
            ((TileEnergyCoreStabilizer)tile).isCoreActive.value = coreActive;
        }
    }

    public boolean validateStructure() {
        boolean valid = this.checkStabilizers();
        this.coreValid.value = this.coreStructure.checkTier(this.tier.value);
        if (!this.coreValid.value) {
            valid = false;
        }
        if (!valid && this.active.value) {
            this.active.value = false;
            this.deactivateCore();
        }
        this.structureValid.value = valid;
        return valid;
    }

    public boolean checkStabilizers() {
        boolean flag = true;
        if (this.stabilizersOK.value) {
            for (SyncableVec3I offset : this.stabOffsets) {
                BlockPos tilePos = this.field_174879_c.func_177982_a(-offset.vec.x, -offset.vec.y, -offset.vec.z);
                TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
                if (tile instanceof TileEnergyCoreStabilizer && ((TileEnergyCoreStabilizer)tile).hasCoreLock.value && ((TileEnergyCoreStabilizer)tile).getCore() == this && ((TileEnergyCoreStabilizer)tile).isStabilizerValid(this.tier.value, this)) continue;
                flag = false;
                break;
            }
            if (!flag) {
                this.stabilizersOK.value = false;
                this.releaseStabilizers();
            }
        } else {
            for (int orient = 1; orient < STAB_ORIENTATIONS.length; ++orient) {
                EnumFacing[] dirs = STAB_ORIENTATIONS[orient];
                ArrayList<TileEnergyCoreStabilizer> stabsFound = new ArrayList<TileEnergyCoreStabilizer>();
                block2: for (int fIndex = 0; fIndex < dirs.length; ++fIndex) {
                    EnumFacing facing = dirs[fIndex];
                    for (int dist = 0; dist < 16; ++dist) {
                        BlockPos pos1 = this.field_174879_c.func_177982_a(facing.func_82601_c() * dist, facing.func_96559_d() * dist, facing.func_82599_e() * dist);
                        TileEntity stabilizer = this.field_145850_b.func_175625_s(pos1);
                        if (!(stabilizer instanceof TileEnergyCoreStabilizer) || ((TileEnergyCoreStabilizer)stabilizer).hasCoreLock.value && !((TileEnergyCoreStabilizer)stabilizer).getCore().equals(this) || !((TileEnergyCoreStabilizer)stabilizer).isStabilizerValid(this.tier.value, this)) continue;
                        stabsFound.add((TileEnergyCoreStabilizer)stabilizer);
                        continue block2;
                    }
                }
                if (stabsFound.size() == 4) {
                    for (TileEnergyCoreStabilizer stab : stabsFound) {
                        this.stabOffsets[stabsFound.indexOf((Object)((Object)stab))].vec = new Vec3I(this.field_174879_c.func_177958_n() - stab.func_174877_v().func_177958_n(), this.field_174879_c.func_177956_o() - stab.func_174877_v().func_177956_o(), this.field_174879_c.func_177952_p() - stab.func_174877_v().func_177952_p());
                        stab.setCore(this);
                    }
                    this.stabilizersOK.value = true;
                    break;
                }
                flag = false;
            }
        }
        return flag;
    }

    private void releaseStabilizers() {
        for (SyncableVec3I offset : this.stabOffsets) {
            BlockPos tilePos = this.field_174879_c.func_177982_a(-offset.vec.x, -offset.vec.y, -offset.vec.z);
            TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
            if (tile instanceof TileEnergyCoreStabilizer) {
                ((TileEnergyCoreStabilizer)tile).hasCoreLock.value = false;
                ((TileEnergyCoreStabilizer)tile).coreOffset.vec.y = 0;
            }
            offset.vec = new Vec3I(0, -1, 0);
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long energyReceived = Math.min(this.getExtendedCapacity() - this.energy.value, (long)maxReceive);
        if (!simulate) {
            this.energy.value += energyReceived;
        }
        return (int)energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        long energyExtracted = Math.min(this.energy.value, (long)maxExtract);
        if (!simulate) {
            this.energy.value -= energyExtracted;
        }
        return (int)energyExtracted;
    }

    @Override
    public long getExtendedStorage() {
        return this.energy.value;
    }

    @Override
    public long getExtendedCapacity() {
        return this.getCapacity();
    }

    public void writeDataToNBT(NBTTagCompound compound) {
    }

    public void readDataFromNBT(NBTTagCompound compound) {
    }

    public boolean isStructureValid() {
        return this.structureValid.value;
    }

    public boolean isController() {
        return true;
    }

    public boolean hasSatelliteStructures() {
        return false;
    }

    public IMultiBlock getController() {
        return this;
    }

    public LinkedList<IMultiBlock> getSatelliteControllers() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }
}

