/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiHoverPopup;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiTextField;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.IDisplayComponentFactory;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.w3c.dom.Element;

public class DCImage
extends DisplayComponentBase {
    public static final String ATTRIB_URL = "imgURL";
    public static final String ATTRIB_SCALE = "scale";
    public String url;
    public int scale;
    public DLResourceLocation resourceLocation;
    public boolean ltComplete = false;

    public DCImage(GuiModWiki modularGui, String componentType, TreeBranchRoot branch) {
        super(modularGui, componentType, branch);
        this.ySize = 20;
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        if (this.resourceLocation == null) {
            return;
        }
        double setScale = (double)this.scale / 100.0;
        if (this.resourceLocation.dlFailed || !this.resourceLocation.dlFinished) {
            setScale = 2.0;
        }
        int texXSize = this.resourceLocation.width;
        int texYSize = this.resourceLocation.height;
        double scaledWidth = Math.min((double)(this.xSize - 4), (double)texXSize * setScale);
        double renderScale = scaledWidth / (double)texXSize;
        double scaledHeight = (double)texYSize * renderScale;
        this.bindTexture((ResourceLocation)this.resourceLocation);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int texXPos = (int)(this.alignment == EnumAlignment.LEFT ? (double)(this.xPos + 2) : (this.alignment == EnumAlignment.CENTER ? (double)(this.xPos + this.xSize / 2) - scaledWidth / 2.0 : (double)(this.xPos + this.xSize) - scaledWidth - 2.0));
        this.drawScaledCustomSizeModalRect(texXPos, this.yPos, 0.0, 0.0, texXSize, texYSize, scaledWidth, scaledHeight, texXSize, texYSize);
    }

    public void renderForegroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderForegroundLayer(minecraft, mouseX, mouseY, partialTicks);
        if (this.isMouseOver(mouseX, mouseY) && mouseY > this.list.yPos + this.list.topPadding) {
            LinkedList<String> toolTip = new LinkedList<String>();
            if (this.resourceLocation == null) {
                toolTip.add(TextFormatting.DARK_RED + "An unknown error occurred...");
            } else if (GuiScreen.func_146272_n()) {
                toolTip.add(TextFormatting.DARK_RED + "Click to re-download image.");
            } else if (this.resourceLocation.dlFailed) {
                toolTip.add(TextFormatting.DARK_RED + "Image download failed! Click to retry.");
            } else if (!this.resourceLocation.dlFinished) {
                toolTip.add(TextFormatting.BLUE + "Downloading image...");
            } else {
                toolTip.add(TextFormatting.GREEN + "Right-Click to open image in browser.");
            }
            this.drawHoveringText(toolTip, mouseX, mouseY, this.fontRenderer, this.modularGui.screenWidth(), this.modularGui.screenHeight());
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.resourceLocation == null) {
                return false;
            }
            if (GuiScreen.func_146272_n()) {
                DLRSCache.clearFileCache((String)this.url);
                this.resourceLocation = DLRSCache.getResource((String)this.url);
                this.ltComplete = false;
                this.ySize = 32;
                this.list.schedualUpdate();
            } else if (this.resourceLocation.dlFailed) {
                DLRSCache.clearFileCache((String)this.url);
                this.resourceLocation = DLRSCache.getResource((String)this.url);
                this.ltComplete = false;
            } else if (this.resourceLocation.dlFinished && mouseButton == 1) {
                try {
                    ReflectionHelper.setPrivateValue(GuiScreen.class, (Object)((Object)this.branch.guiWiki), (Object)new URI(this.url), (String[])new String[]{"clickedLinkURI", "field_175286_t"});
                    this.mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this.branch.guiWiki, this.url, 31102009, false));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public LinkedList<MGuiElementBase> getEditControls() {
        LinkedList<MGuiElementBase> list = super.getEditControls();
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "TOGGLE_ALIGN", 0, 0, 26, 12, "Align"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Horizontal Alignment"}));
        list.add((MGuiElementBase)new MGuiLabel(this.modularGui, 0, 0, 22, 12, "URL:").setAlignment(EnumAlignment.CENTER));
        MGuiTextField urlField = new MGuiTextField(this.modularGui, 0, 0, 150, 12, this.fontRenderer).setListener((IMGuiListener)this).setMaxStringLength(2048).setText(this.url);
        urlField.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{"Set the image URL. Note some URL's may not be supported.", TextFormatting.GREEN + "Will Auto-Save 3 seconds after you stop typing."}, (MGuiElementBase)urlField));
        urlField.setId("URL");
        list.add((MGuiElementBase)urlField);
        list.add((MGuiElementBase)new MGuiLabel(this.modularGui, 0, 0, 30, 12, "Scale:").setAlignment(EnumAlignment.CENTER));
        MGuiTextField scaleField = new MGuiTextField(this.modularGui, 0, 0, 36, 12, this.fontRenderer).setListener((IMGuiListener)this).setMaxStringLength(2048).setText(String.valueOf(this.scale));
        scaleField.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{"Set the image scale (As a percentage of the actual size)", TextFormatting.GOLD + "The size of the image will be limited by both this and the width of the GUI.", TextFormatting.GOLD + "Whichever value is smaller will take priority.", TextFormatting.GREEN + "Will save as you type."}, (MGuiElementBase)scaleField));
        scaleField.setId("SCALE");
        scaleField.setValidator((Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                try {
                    Integer.parseInt(input);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        });
        list.add((MGuiElementBase)scaleField);
        return list;
    }

    @Override
    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        super.onMGuiEvent(eventString, eventElement);
        if (eventElement.id.equals("SCALE") && eventString.equals("TEXT_FIELD_CHANGED") && eventElement instanceof MGuiTextField) {
            if (StringUtils.func_151246_b((String)((MGuiTextField)eventElement).getText())) {
                return;
            }
            int newScale = 1;
            try {
                newScale = Integer.parseInt(((MGuiTextField)eventElement).getText());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (newScale < 1) {
                newScale = 1;
            }
            this.element.setAttribute(ATTRIB_SCALE, String.valueOf(newScale));
            int pos = ((MGuiTextField)eventElement).getCursorPosition();
            this.save();
            for (MGuiElementBase element : this.branch.guiWiki.contentWindow.editControls) {
                if (!(element instanceof MGuiTextField) || !element.id.equals("SCALE")) continue;
                ((MGuiTextField)element).setFocused(true);
                ((MGuiTextField)element).setCursorPosition(pos);
                break;
            }
        } else if (eventElement.id.equals("URL") && eventString.equals("TEXT_FIELD_CHANGED") && eventElement instanceof MGuiTextField) {
            this.element.setAttribute(ATTRIB_URL, ((MGuiTextField)eventElement).getText());
            this.url = ((MGuiTextField)eventElement).getText();
            this.requiresSave = true;
            this.saveTimer = 60;
        }
    }

    @Override
    public void onCreated() {
        this.element.setAttribute(ATTRIB_URL, "http://www.rd.com/wp-content/uploads/sites/2/2016/02/06-train-cat-shake-hands.jpg");
        this.element.setAttribute(ATTRIB_SCALE, "100");
    }

    @Override
    public void setXSize(int xSize) {
        super.setXSize(xSize);
        if (this.resourceLocation == null) {
            this.ltComplete = false;
            return;
        }
        double setScale = (double)this.scale / 100.0;
        int texXSize = this.resourceLocation.width;
        int texYSize = this.resourceLocation.height;
        double scaledWidth = Math.min((double)(xSize - 4), (double)texXSize * setScale);
        double renderScale = scaledWidth / (double)texXSize;
        this.ySize = (int)((double)texYSize * renderScale);
    }

    @Override
    public boolean onUpdate() {
        if (!this.ltComplete && this.resourceLocation != null && this.resourceLocation.dlFinished) {
            this.ltComplete = true;
            double setScale = (double)this.scale / 100.0;
            int texXSize = this.resourceLocation.width;
            int texYSize = this.resourceLocation.height;
            double scaledWidth = Math.min((double)(this.xSize - 4), (double)texXSize * setScale);
            double renderScale = scaledWidth / (double)texXSize;
            this.ySize = (int)((double)texYSize * renderScale);
            this.list.schedualUpdate();
        }
        return super.onUpdate();
    }

    @Override
    public void loadFromXML(Element element) {
        super.loadFromXML(element);
        this.url = element.getAttribute(ATTRIB_URL);
        try {
            this.scale = Integer.parseInt(element.getAttribute(ATTRIB_SCALE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.scale < 1) {
            this.scale = 1;
        }
        this.resourceLocation = DLRSCache.getResource((String)this.url);
    }

    public static class Factory
    implements IDisplayComponentFactory {
        @Override
        public DisplayComponentBase createNewInstance(GuiModWiki guiWiki, TreeBranchRoot branch) {
            DCImage component = new DCImage(guiWiki, this.getID(), branch);
            component.setWorldAndResolution(guiWiki.field_146297_k, guiWiki.screenWidth(), guiWiki.screenHeight());
            return component;
        }

        @Override
        public String getID() {
            return "image";
        }
    }
}

