/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiHoverPopup;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiList;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiSelectDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiTextField;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.WikiConfig;
import com.brandon3055.draconicevolution.client.gui.modwiki.WikiContentWindow;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.WikiDocManager;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentRegistry;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.IDisplayComponentFactory;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DCSplitContainer
extends DisplayComponentBase {
    public static final String ATTRIB_VALIGNMENT = "vAlignment";
    public static final String ATTRIB_WIDTH = "width";
    public int splitMinWidth = 100;
    public DisplayComponentBase componentLeft;
    public DisplayComponentBase componentRight;
    public EnumAlignment.Vertical vAlignment = EnumAlignment.Vertical.TOP;
    public MGuiList dummyListLeft;
    public MGuiList dummyListRight;

    public DCSplitContainer(GuiModWiki modularGui, String componentType, TreeBranchRoot branch) {
        super(modularGui, componentType, branch);
        this.ySize = 8;
    }

    @Override
    public void setXSize(int xSize) {
        int xSplit;
        super.setXSize(xSize);
        int n = this.alignment == EnumAlignment.LEFT ? this.xPos + this.splitMinWidth : (xSplit = this.alignment == EnumAlignment.CENTER ? this.xPos + xSize / 2 : this.xPos + xSize - this.splitMinWidth);
        if (xSize - this.xPos < 16) {
            xSplit = this.xPos + 16;
        } else if (this.xPos + xSize - xSplit < 16) {
            xSplit = this.xPos + xSize - 16;
        }
        if (this.componentLeft != null) {
            this.componentLeft.setXPos(this.xPos);
            this.componentLeft.setXSize(xSplit - this.xPos);
            this.ySize = this.componentLeft.ySize;
        }
        if (this.componentRight != null) {
            this.componentRight.setXPos(xSplit);
            this.componentRight.setXSize(this.xPos + xSize - xSplit);
            if (this.componentRight.ySize > this.ySize) {
                this.ySize = this.componentRight.ySize;
            }
        }
        DisplayComponentBase smaller = null;
        if (this.componentLeft != null && this.componentLeft.ySize < this.ySize) {
            smaller = this.componentLeft;
        } else if (this.componentRight != null && this.componentRight.ySize < this.ySize) {
            smaller = this.componentRight;
        }
        if (smaller != null) {
            int newY = 0;
            switch (this.vAlignment) {
                case TOP: {
                    newY = this.yPos;
                    break;
                }
                case MIDDLE: {
                    newY = this.yPos + this.ySize / 2 - smaller.ySize / 2;
                    break;
                }
                case BOTTOM: {
                    newY = this.yPos + this.ySize - smaller.ySize;
                }
            }
            smaller.moveBy(0, newY - smaller.yPos);
        }
    }

    public void setList(MGuiList list) {
        super.setList(list);
        if (this.componentLeft != null) {
            this.componentLeft.setList(list);
        }
        if (this.componentRight != null) {
            this.componentRight.setList(list);
        }
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        if (WikiConfig.editMode && WikiConfig.drawEditInfo) {
            this.zOffset += 10.0;
            if (this.branch.guiWiki.contentWindow.editingComponent == this) {
                this.drawBorderedRect(this.xPos, this.yPos, this.xSize, this.ySize, 0.8, 0, -16776961);
            }
            int x = this.alignment == EnumAlignment.LEFT ? this.xPos + this.splitMinWidth : (this.alignment == EnumAlignment.CENTER ? this.xPos + this.xSize / 2 : this.xPos + this.xSize - this.splitMinWidth);
            this.drawColouredRect(x, this.yPos, 0.8, this.ySize, -16776961);
            this.zOffset -= 10.0;
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public LinkedList<MGuiElementBase> getEditControls() {
        LinkedList<MGuiElementBase> list = super.getEditControls();
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "TOGGLE_ALIGN", 0, 0, this.fontRenderer.func_78256_a("Horizontal Align") + 4, 12, "Horizontal Align"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Horizontal divider Alignment between Fixed Left Column Size, 50/50 and Fixed Right Column Size", "Current: " + this.alignment}));
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "TOGGLE_V_ALIGN", 0, 0, this.fontRenderer.func_78256_a("Vertical Align") + 4, 12, "Vertical Align"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Vertical alignment of smallest component between Top, Middle and Bottom.", "Current: " + this.vAlignment}));
        if (this.alignment != EnumAlignment.CENTER) {
            list.add((MGuiElementBase)new MGuiLabel(this.modularGui, 0, 0, 48, 12, "Min Width:").setAlignment(EnumAlignment.CENTER));
            MGuiTextField colourField = new MGuiTextField(this.modularGui, 0, 0, 45, 12, this.fontRenderer).setListener((IMGuiListener)this).setMaxStringLength(6);
            colourField.setId("WIDTH");
            String s = this.alignment == EnumAlignment.LEFT ? "Set width of left column" : "Set width of right column";
            colourField.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{s}, (MGuiElementBase)colourField));
            colourField.setText(String.valueOf(this.splitMinWidth));
            colourField.setValidator((Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    try {
                        Integer.parseInt(input);
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
            });
            list.add((MGuiElementBase)colourField);
        }
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "SET_LEFT", 0, 0, this.fontRenderer.func_78256_a("Set Left") + 4, 12, "Set Left"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Set the left sub display component."}));
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "SET_RIGHT", 0, 0, this.fontRenderer.func_78256_a("Set Right") + 4, 12, "Set Right"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Set the right sub display component."}));
        return list;
    }

    @Override
    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        block18: {
            String type;
            String side;
            block21: {
                block20: {
                    block19: {
                        super.onMGuiEvent(eventString, eventElement);
                        if (!(eventElement instanceof MGuiButton) || !((MGuiButton)eventElement).buttonName.equals("TOGGLE_V_ALIGN")) break block19;
                        this.vAlignment = this.vAlignment == EnumAlignment.Vertical.TOP ? EnumAlignment.Vertical.MIDDLE : (this.vAlignment == EnumAlignment.Vertical.MIDDLE ? EnumAlignment.Vertical.BOTTOM : EnumAlignment.Vertical.TOP);
                        this.element.setAttribute(ATTRIB_VALIGNMENT, this.vAlignment.name());
                        this.save();
                        break block18;
                    }
                    if (!(eventElement instanceof MGuiButton) || !((MGuiButton)eventElement).buttonName.startsWith("SET_")) break block20;
                    WikiContentWindow cw = this.branch.guiWiki.contentWindow;
                    if (cw.addSelector != null) {
                        this.modularGui.getManager().remove((MGuiElementBase)cw.addSelector);
                        cw.addSelector = null;
                        return;
                    }
                    cw.addSelector = new MGuiSelectDialog(this.modularGui, cw.xPos, cw.yPos, 10, 50);
                    cw.addSelector.setId(((MGuiButton)eventElement).buttonName);
                    ArrayList<MGuiLabel> list = new ArrayList<MGuiLabel>();
                    int width = 10;
                    for (String option : DisplayComponentRegistry.REGISTRY.keySet()) {
                        if (option.equals("splitContainer")) continue;
                        int optionWidth = this.fontRenderer.func_78256_a(option) + 4;
                        if (optionWidth + 10 > width) {
                            width = optionWidth + 10;
                        }
                        list.add(new MGuiLabel(this.modularGui, 0, 0, optionWidth, 12, option));
                    }
                    list.add(new MGuiLabel(this.modularGui, 0, 0, this.fontRenderer.func_78256_a("CLEAR") + 4, 12, "CLEAR"));
                    cw.addSelector.xPos = eventElement.xPos;
                    cw.addSelector.yPos = eventElement.yPos + 12;
                    cw.addSelector.ySize = Math.min(list.size() * 12 + 4, cw.ySize - 12);
                    cw.addSelector.initElement();
                    cw.addSelector.setOptions(list);
                    cw.addSelector.setListener((IMGuiListener)this);
                    this.modularGui.getManager().add((MGuiElementBase)cw.addSelector, 2);
                    break block18;
                }
                if (!eventElement.id.equals("WIDTH") || !eventString.equals("TEXT_FIELD_CHANGED") || !(eventElement instanceof MGuiTextField)) break block21;
                if (StringUtils.func_151246_b((String)((MGuiTextField)eventElement).getText())) {
                    return;
                }
                int newWidth = 1;
                try {
                    newWidth = Integer.parseInt(((MGuiTextField)eventElement).getText());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (newWidth < 10) {
                    newWidth = 10;
                }
                this.element.setAttribute(ATTRIB_WIDTH, String.valueOf(newWidth));
                int pos = ((MGuiTextField)eventElement).getCursorPosition();
                this.save();
                for (MGuiElementBase element : this.branch.guiWiki.contentWindow.editControls) {
                    if (!(element instanceof MGuiTextField) || !element.id.equals("WIDTH")) continue;
                    ((MGuiTextField)element).setFocused(true);
                    ((MGuiTextField)element).setCursorPosition(pos);
                    break block18;
                }
                break block18;
            }
            if (!eventString.equals("SELECTOR_PICK") || !(eventElement instanceof MGuiLabel)) break block18;
            WikiContentWindow cw = this.branch.guiWiki.contentWindow;
            if (cw.addSelector.id.endsWith("LEFT")) {
                side = "LEFT";
                if (this.componentLeft != null) {
                    this.element.removeChild(this.componentLeft.element);
                }
            } else if (cw.addSelector.id.endsWith("RIGHT")) {
                side = "RIGHT";
                if (this.componentRight != null) {
                    this.element.removeChild(this.componentRight.element);
                }
            } else {
                return;
            }
            if (!(type = ((MGuiLabel)eventElement).displayString).equals("CLEAR")) {
                Element newElement = this.element.getOwnerDocument().createElement("content");
                newElement.setAttribute("splitSide", side);
                newElement.setAttribute("index", "0");
                newElement.setAttribute("type", type);
                this.element.appendChild(newElement);
                DisplayComponentBase component = DisplayComponentRegistry.createComponent(this.branch.guiWiki, type, newElement, this.branch);
                if (component == null) {
                    LogHelper.error("Failed to create display component... This should not happen.");
                    return;
                }
                component.container = this;
                component.onCreated();
            }
            this.modularGui.getManager().remove((MGuiElementBase)cw.addSelector);
            cw.addSelector = null;
            try {
                this.branch.save();
                WikiDocManager.reload(false, true, true);
                this.branch.guiWiki.wikiDataTree.reOpenLast();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onCreated() {
        this.element.setAttribute(ATTRIB_VALIGNMENT, EnumAlignment.Vertical.TOP.name());
    }

    @Override
    public void loadFromXML(Element element) {
        super.loadFromXML(element);
        if (element.hasAttribute(ATTRIB_VALIGNMENT)) {
            String align = element.getAttribute(ATTRIB_VALIGNMENT);
            this.vAlignment = EnumAlignment.Vertical.valueOf((String)align.toUpperCase());
        }
        if (element.hasAttribute(ATTRIB_WIDTH)) {
            try {
                this.splitMinWidth = Integer.parseInt(element.getAttribute(ATTRIB_WIDTH));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.splitMinWidth < 16) {
            this.splitMinWidth = 16;
        }
        NodeList nodeList = element.getElementsByTagName("content");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getParentNode() != element) continue;
            if (!(node instanceof Element)) {
                LogHelper.dev("Node Is Not An Element: " + node);
                continue;
            }
            Element content = (Element)node;
            String type = content.getAttribute("type");
            DisplayComponentBase displayComponent = DisplayComponentRegistry.createComponent(this.branch.guiWiki, type, content, this.branch);
            if (displayComponent == null) continue;
            displayComponent.container = this;
            displayComponent.setList(this.list);
            if (content.hasAttribute("splitSide") && content.getAttribute("splitSide").equals("LEFT")) {
                this.componentLeft = displayComponent;
                this.addChild((MGuiElementBase)this.componentLeft);
                continue;
            }
            if (content.hasAttribute("splitSide") && content.getAttribute("splitSide").equals("RIGHT")) {
                this.componentRight = displayComponent;
                this.addChild((MGuiElementBase)this.componentRight);
                continue;
            }
            LogHelper.error("Found un-designated content element for SplitContainer in " + this.branch.branchID);
        }
    }

    public static class Factory
    implements IDisplayComponentFactory {
        @Override
        public DisplayComponentBase createNewInstance(GuiModWiki guiWiki, TreeBranchRoot branch) {
            DCSplitContainer component = new DCSplitContainer(guiWiki, this.getID(), branch);
            component.setWorldAndResolution(guiWiki.field_146297_k, guiWiki.screenWidth(), guiWiki.screenHeight());
            return component;
        }

        @Override
        public String getID() {
            return "splitContainer";
        }
    }
}

